/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf.processor;

import com.google.common.primitives.Ints;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.OverlapDetector;
import htsjdk.variant.vcf.VCFFileReader;
import htsjdk.variant.vcf.VCFHeader;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import picard.vcf.processor.VcfFileSegment;

public abstract class VcfFileSegmentGenerator {
    static final Log LOG = Log.getInstance(VcfFileSegmentGenerator.class);

    public abstract Iterable<VcfFileSegment> forVcf(File var1);

    public static VcfFileSegmentGenerator byWholeContigSubdividingWithWidth(long segmentWidth) {
        return WidthLimitingDecorator.wrapping(ByWholeContig.getInstance(), segmentWidth);
    }

    public static <T> VcfFileSegmentGenerator excludingNonOverlaps(final VcfFileSegmentGenerator strategy, final OverlapDetector<T> overlaps) {
        return new VcfFileSegmentGenerator(){

            @Override
            public Iterable<VcfFileSegment> forVcf(File vcf) {
                return StreamSupport.stream(strategy.forVcf(vcf).spliterator(), false).filter(segment -> {
                    boolean keep;
                    boolean bl = keep = !overlaps.getOverlaps(new Interval(segment.contig(), segment.start(), segment.stop())).isEmpty();
                    if (!keep) {
                        LOG.debug(String.format("Ignoring segment because it does not overlap with detector, %s::%s:%s-%s", segment.vcf().getName(), segment.contig(), segment.start(), segment.stop()));
                    }
                    return keep;
                }).collect(Collectors.toList());
            }
        };
    }

    static final class WidthLimitingDecorator
    extends VcfFileSegmentGenerator {
        final VcfFileSegmentGenerator underlyingStrategy;
        final long width;

        public static WidthLimitingDecorator wrapping(VcfFileSegmentGenerator basis, long maximumWidth) {
            return new WidthLimitingDecorator(basis, maximumWidth);
        }

        private WidthLimitingDecorator(VcfFileSegmentGenerator underlyingStrategy, long maximumWidth) {
            this.underlyingStrategy = underlyingStrategy;
            this.width = maximumWidth - 1L;
        }

        @Override
        public Iterable<VcfFileSegment> forVcf(File vcf) {
            return StreamSupport.stream(this.underlyingStrategy.forVcf(vcf).spliterator(), false).flatMap(vcfFileSegment -> StreamSupport.stream(new VcfFileSegmentSubdivider((VcfFileSegment)vcfFileSegment).spliterator(), false)).collect(Collectors.toList());
        }

        private final class VcfFileSegmentSubdivider
        implements Iterable<VcfFileSegment> {
            final VcfFileSegment basis;

            private VcfFileSegmentSubdivider(VcfFileSegment basis) {
                this.basis = basis;
            }

            @Override
            public Iterator<VcfFileSegment> iterator() {
                return new Iterator<VcfFileSegment>(){
                    int nextStart;
                    {
                        this.nextStart = VcfFileSegmentSubdivider.this.basis.start();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.nextStart <= VcfFileSegmentSubdivider.this.basis.stop();
                    }

                    @Override
                    public VcfFileSegment next() {
                        final int start = this.nextStart;
                        VcfFileSegment ret = new VcfFileSegment(){

                            @Override
                            public int start() {
                                return start;
                            }

                            @Override
                            public int stop() {
                                return Ints.checkedCast(Math.min((long)start + WidthLimitingDecorator.this.width, (long)VcfFileSegmentSubdivider.this.basis.stop()));
                            }

                            @Override
                            public String contig() {
                                return VcfFileSegmentSubdivider.this.basis.contig();
                            }

                            @Override
                            public File vcf() {
                                return VcfFileSegmentSubdivider.this.basis.vcf();
                            }
                        };
                        this.nextStart = (int)((long)this.nextStart + (WidthLimitingDecorator.this.width + 1L));
                        return ret;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        }
    }

    static class ByWholeContig
    extends VcfFileSegmentGenerator {
        private static final ByWholeContig singleton = new ByWholeContig();

        ByWholeContig() {
        }

        public static ByWholeContig getInstance() {
            return singleton;
        }

        @Override
        public Iterable<VcfFileSegment> forVcf(File vcf) {
            List<SAMSequenceRecord> samSequenceRecords = ByWholeContig.readSequences(vcf);
            return samSequenceRecords.stream().map(samSequenceRecord -> VcfFileSegment.ofWholeSequence(samSequenceRecord, vcf)).collect(Collectors.toList());
        }

        private static List<SAMSequenceRecord> readSequences(File vcf) {
            VCFFileReader reader = new VCFFileReader(vcf);
            VCFHeader header = reader.getFileHeader();
            SAMSequenceDictionary dict = header.getSequenceDictionary();
            reader.close();
            return dict.getSequences();
        }
    }
}

