/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.writer.Options;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.variantcontext.writer.VariantContextWriterBuilder;
import htsjdk.variant.vcf.VCFFileReader;
import htsjdk.variant.vcf.VCFHeader;
import java.io.File;
import java.util.Iterator;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.VariantManipulationProgramGroup;

@CommandLineProgramProperties(summary="Converts VCF to BCF or BCF to VCF.  This tool converts files between the plain-text VCF format and its binary compressed equivalent, BCF. Input and output formats are determined by file extensions specified in the file names. For best results, it is recommended to ensure that an index file is present and set the REQUIRE_INDEX option to true.<br /><h4>Usage example:</h4><pre>java -jar picard.jar VcfFormatConverter \\<br />      I=input.vcf \\<br />      O=output.bcf \\<br />      REQUIRE_INDEX=true</pre><hr />", oneLineSummary="Converts VCF to BCF or BCF to VCF.  ", programGroup=VariantManipulationProgramGroup.class)
@DocumentedFeature
public class VcfFormatConverter
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Converts VCF to BCF or BCF to VCF.  ";
    static final String USAGE_DETAILS = "This tool converts files between the plain-text VCF format and its binary compressed equivalent, BCF. Input and output formats are determined by file extensions specified in the file names. For best results, it is recommended to ensure that an index file is present and set the REQUIRE_INDEX option to true.<br /><h4>Usage example:</h4><pre>java -jar picard.jar VcfFormatConverter \\<br />      I=input.vcf \\<br />      O=output.bcf \\<br />      REQUIRE_INDEX=true</pre><hr />";
    public static final Log LOG = Log.getInstance(VcfFormatConverter.class);
    @Argument(doc="The BCF or VCF input file.", shortName="I")
    public File INPUT;
    @Argument(doc="The BCF or VCF output file name.", shortName="O")
    public File OUTPUT;
    @Argument(doc="Fail if an index is not available for the input VCF/BCF")
    public Boolean REQUIRE_INDEX = true;

    public VcfFormatConverter() {
        this.CREATE_INDEX = true;
    }

    @Override
    protected int doWork() {
        ProgressLogger progress = new ProgressLogger(LOG, 10000);
        IOUtil.assertFileIsReadable(this.INPUT);
        IOUtil.assertFileIsWritable(this.OUTPUT);
        VCFFileReader reader = new VCFFileReader(this.INPUT, (boolean)this.REQUIRE_INDEX);
        VCFHeader header = new VCFHeader(reader.getFileHeader());
        SAMSequenceDictionary sequenceDictionary = header.getSequenceDictionary();
        if (this.CREATE_INDEX.booleanValue() && sequenceDictionary == null) {
            throw new PicardException("A sequence dictionary must be available in the input file when creating indexed output.");
        }
        VariantContextWriterBuilder builder = new VariantContextWriterBuilder().setOutputFile(this.OUTPUT).setReferenceDictionary(sequenceDictionary);
        if (this.CREATE_INDEX.booleanValue()) {
            builder.setOption(Options.INDEX_ON_THE_FLY);
        } else {
            builder.unsetOption(Options.INDEX_ON_THE_FLY);
        }
        VariantContextWriter writer = builder.build();
        writer.writeHeader(header);
        Iterator iterator = reader.iterator();
        while (iterator.hasNext()) {
            VariantContext context = (VariantContext)iterator.next();
            writer.add(context);
            progress.record(context.getContig(), context.getStart());
        }
        CloserUtil.close(iterator);
        CloserUtil.close(reader);
        writer.close();
        return 0;
    }
}

