/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.fastq.FastqRecord;
import htsjdk.samtools.fastq.FastqWriter;
import htsjdk.samtools.fastq.FastqWriterFactory;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import picard.PicardException;
import picard.cmdline.programgroups.ReadDataManipulationProgramGroup;
import picard.sam.SamToFastq;

@CommandLineProgramProperties(summary="Converts a SAM or BAM file to FASTQ alongside FASTQs created from tags. Extracts read sequences and qualities from the input SAM/BAM file and SAM/BAM tags and writes them into the output file in Sanger FASTQ format. See <a href=\"http://maq.sourceforge.net/fastq.shtml\">MAQ FASTQ specification</a> for details.<br /> <br />The following example will create two FASTQs from tags.  One will be converted with the base sequence coming from the \"CR\" tag and base quality from the \"CY\" tag.  The other fastq will be converted with the base sequence coming from the \"CB\" and \"UR\" tags concatenated together with no separator (not specified on command line) with the base qualities coming from the \"CY\" and \"UY\" tags concatenated together.  The two files will be named CR.fastq and CB_UR.fastq.<br /><pre>java -jar picard.jar SamToFastqWithTags <br />     I=input.bam<br />     FASTQ=output.fastq<br />     SEQUENCE_TAG_GROUP=CR<br />     QUALITY_TAG_GROUP=CY<br />     SEQUENCE_TAG_GROUP=\"CB,UR\"<br />     QUALITY_TAG_GROUP=\"CY,UY\"</pre><hr />", oneLineSummary="Converts a SAM or BAM file to FASTQ alongside FASTQs created from tags.", programGroup=ReadDataManipulationProgramGroup.class)
public class SamToFastqWithTags
extends SamToFastq {
    static final String USAGE_SUMMARY = "Converts a SAM or BAM file to FASTQ alongside FASTQs created from tags.";
    static final String USAGE_DETAILS = " Extracts read sequences and qualities from the input SAM/BAM file and SAM/BAM tags and writes them into the output file in Sanger FASTQ format. See <a href=\"http://maq.sourceforge.net/fastq.shtml\">MAQ FASTQ specification</a> for details.<br /> <br />The following example will create two FASTQs from tags.  One will be converted with the base sequence coming from the \"CR\" tag and base quality from the \"CY\" tag.  The other fastq will be converted with the base sequence coming from the \"CB\" and \"UR\" tags concatenated together with no separator (not specified on command line) with the base qualities coming from the \"CY\" and \"UY\" tags concatenated together.  The two files will be named CR.fastq and CB_UR.fastq.<br /><pre>java -jar picard.jar SamToFastqWithTags <br />     I=input.bam<br />     FASTQ=output.fastq<br />     SEQUENCE_TAG_GROUP=CR<br />     QUALITY_TAG_GROUP=CY<br />     SEQUENCE_TAG_GROUP=\"CB,UR\"<br />     QUALITY_TAG_GROUP=\"CY,UY\"</pre><hr />";
    @Argument(shortName="STG", doc="List of comma separated tag values to extract from Input SAM/BAM to be used as read sequence", minElements=1)
    public List<String> SEQUENCE_TAG_GROUP;
    @Argument(shortName="QTG", doc="List of comma separated tag values to extract from Input SAM/BAM to be used as read qualities", optional=true)
    public List<String> QUALITY_TAG_GROUP;
    @Argument(shortName="SEP", doc="List of any sequences (e.g. 'AACCTG`) to put in between each comma separated list of sequence tags in each SEQUENCE_TAG_GROUP (STG)", optional=true)
    public List<String> TAG_GROUP_SEPERATOR;
    @Argument(shortName="GZOPTG", doc="Compress output FASTQ files per Tag grouping using gzip and append a .gz extension to the file names.")
    public Boolean COMPRESS_OUTPUTS_PER_TAG_GROUP = false;
    private final Log log = Log.getInstance(SamToFastqWithTags.class);
    private static final String TAG_SPLIT_DEFAULT_SEP = "";
    private static final String TAG_SPLIT_QUAL = "~";
    private ArrayList<String[]> SPLIT_SEQUENCE_TAGS;
    private ArrayList<String[]> SPLIT_QUALITY_TAGS;
    private ArrayList<String> SPLIT_SEPARATOR_TAGS;

    @Override
    protected void initializeAdditionalWriters() {
        this.setupTagSplitValues();
    }

    @Override
    protected void handleAdditionalRecords(SAMRecord currentRecord, Map<SAMReadGroupRecord, List<FastqWriter>> tagWriters, SAMRecord read1, SAMRecord read2) {
        List<FastqWriter> rgTagWriters = tagWriters.get(currentRecord.getReadGroup());
        if (currentRecord.getReadPairedFlag()) {
            if (read1 != null && read2 != null) {
                this.writeTagRecords(read1, 1, rgTagWriters);
                this.writeTagRecords(read2, 2, rgTagWriters);
            }
        } else {
            this.writeTagRecords(currentRecord, null, rgTagWriters);
        }
    }

    @Override
    protected Map<SAMReadGroupRecord, List<FastqWriter>> generateAdditionalWriters(List<SAMReadGroupRecord> readGroups, FastqWriterFactory factory) {
        return this.generateTagWriters(readGroups, factory);
    }

    private Map<SAMReadGroupRecord, List<FastqWriter>> generateTagWriters(List<SAMReadGroupRecord> samReadGroupRecords, FastqWriterFactory factory) {
        HashMap<SAMReadGroupRecord, List<FastqWriter>> writerMap = new HashMap<SAMReadGroupRecord, List<FastqWriter>>();
        if (!this.OUTPUT_PER_RG) {
            List<FastqWriter> tagFastqWriters = this.makeTagWriters(null, factory);
            writerMap.put(null, tagFastqWriters);
            for (SAMReadGroupRecord rg : samReadGroupRecords) {
                writerMap.put(rg, tagFastqWriters);
            }
        } else {
            for (SAMReadGroupRecord rg : samReadGroupRecords) {
                List<FastqWriter> tagWriters = this.makeTagWriters(rg, factory);
                writerMap.put(rg, tagWriters);
            }
        }
        return writerMap;
    }

    private List<FastqWriter> makeTagWriters(SAMReadGroupRecord readGroup, FastqWriterFactory factory) {
        String baseFilename = null;
        if (readGroup != null) {
            if (this.RG_TAG.equalsIgnoreCase("PU")) {
                baseFilename = readGroup.getPlatformUnit() + "_";
            } else if (this.RG_TAG.equalsIgnoreCase("ID")) {
                baseFilename = readGroup.getReadGroupId() + "_";
            }
            if (baseFilename == null) {
                throw new PicardException("The selected RG_TAG: " + this.RG_TAG + " is not present in the bam header.");
            }
        } else {
            baseFilename = TAG_SPLIT_DEFAULT_SEP;
        }
        ArrayList<File> tagFiles = new ArrayList<File>();
        for (String tagSplit : this.SEQUENCE_TAG_GROUP) {
            String fileName = baseFilename + tagSplit.replace(",", "_");
            fileName = IOUtil.makeFileNameSafe(fileName);
            fileName = fileName + (this.COMPRESS_OUTPUTS_PER_TAG_GROUP != false ? ".fastq.gz" : ".fastq");
            File result = this.OUTPUT_DIR != null ? new File(this.OUTPUT_DIR, fileName) : new File(this.FASTQ.getParent(), fileName);
            IOUtil.assertFileIsWritable(result);
            tagFiles.add(result);
        }
        return tagFiles.stream().map(factory::newWriter).collect(Collectors.toList());
    }

    private void setupTagSplitValues() {
        this.SPLIT_SEQUENCE_TAGS = new ArrayList();
        this.SPLIT_QUALITY_TAGS = new ArrayList();
        this.SPLIT_SEPARATOR_TAGS = new ArrayList();
        for (int i = 0; i < this.SEQUENCE_TAG_GROUP.size(); ++i) {
            this.SPLIT_SEQUENCE_TAGS.add(this.SEQUENCE_TAG_GROUP.get(i).trim().split(","));
            this.SPLIT_QUALITY_TAGS.add(this.QUALITY_TAG_GROUP.isEmpty() ? null : this.QUALITY_TAG_GROUP.get(i).trim().split(","));
            this.SPLIT_SEPARATOR_TAGS.add(this.TAG_GROUP_SEPERATOR.isEmpty() ? TAG_SPLIT_DEFAULT_SEP : this.TAG_GROUP_SEPERATOR.get(i));
        }
    }

    private void writeTagRecords(SAMRecord read, Integer mateNumber, List<FastqWriter> tagWriters) {
        if (this.SEQUENCE_TAG_GROUP.isEmpty()) {
            return;
        }
        String seqHeader = mateNumber == null ? read.getReadName() : read.getReadName() + "/" + mateNumber;
        for (int i = 0; i < this.SEQUENCE_TAG_GROUP.size(); ++i) {
            String tmpTagSep = this.SPLIT_SEPARATOR_TAGS.get(i);
            String[] sequenceTagsToWrite = this.SPLIT_SEQUENCE_TAGS.get(i);
            String newSequence = String.join((CharSequence)tmpTagSep, Arrays.stream(sequenceTagsToWrite).map(tag -> this.assertTagExists(read, (String)tag)).collect(Collectors.toList()));
            String tmpQualSep = StringUtils.repeat(TAG_SPLIT_QUAL, tmpTagSep.length());
            String[] qualityTagsToWrite = this.SPLIT_QUALITY_TAGS.get(i);
            String newQual = this.QUALITY_TAG_GROUP.isEmpty() ? StringUtils.repeat(TAG_SPLIT_QUAL, newSequence.length()) : String.join((CharSequence)tmpQualSep, Arrays.stream(qualityTagsToWrite).map(tag -> this.assertTagExists(read, (String)tag)).collect(Collectors.toList()));
            FastqWriter writer = tagWriters.get(i);
            writer.write(new FastqRecord(seqHeader, newSequence, TAG_SPLIT_DEFAULT_SEP, newQual));
        }
    }

    private String assertTagExists(SAMRecord record, String tag) {
        String value = record.getStringAttribute(tag);
        if (value == null) {
            throw new PicardException("Record: " + record.getReadName() + " does have a value for tag: " + tag);
        }
        return value;
    }

    @Override
    protected String[] customCommandLineValidation() {
        ArrayList<String> errors = new ArrayList<String>();
        if (!this.QUALITY_TAG_GROUP.isEmpty() && this.SEQUENCE_TAG_GROUP.size() != this.QUALITY_TAG_GROUP.size()) {
            errors.add("QUALITY_TAG_GROUP size must be equal to SEQUENCE_TAG_GROUP or not be specified at all.");
        }
        if (!this.TAG_GROUP_SEPERATOR.isEmpty() && this.SEQUENCE_TAG_GROUP.size() != this.TAG_GROUP_SEPERATOR.size()) {
            errors.add("TAG_GROUP_SEPERATOR size must be equal to SEQUENCE_TAG_GROUP or not be specified at all.");
        }
        return errors.isEmpty() ? super.customCommandLineValidation() : errors.toArray(new String[errors.size()]);
    }
}

