/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import java.io.File;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.ReadDataManipulationProgramGroup;

@CommandLineProgramProperties(summary="Convert a BAM file to a SAM file, or SAM to BAM.\nInput and output formats are determined by file extension.", oneLineSummary="Convert a BAM file to a SAM file, or a SAM to a BAM", programGroup=ReadDataManipulationProgramGroup.class)
@DocumentedFeature
public class SamFormatConverter
extends CommandLineProgram {
    @Argument(doc="The BAM or SAM file to parse.", shortName="I")
    public File INPUT;
    @Argument(doc="The BAM or SAM output file. ", shortName="O")
    public File OUTPUT;

    @Override
    protected int doWork() {
        SamFormatConverter.convert(this.INPUT, this.OUTPUT, this.REFERENCE_SEQUENCE, this.CREATE_INDEX);
        return 0;
    }

    public static void convert(File input, File output, File referenceSequence, Boolean createIndex) {
        IOUtil.assertFileIsReadable(input);
        IOUtil.assertFileIsWritable(output);
        SamReader reader = SamReaderFactory.makeDefault().referenceSequence(referenceSequence).open(input);
        SAMFileWriter writer = new SAMFileWriterFactory().makeWriter(reader.getFileHeader(), true, output, referenceSequence);
        if (createIndex.booleanValue() && writer.getFileHeader().getSortOrder() != SAMFileHeader.SortOrder.coordinate) {
            throw new PicardException("Can't CREATE_INDEX unless sort order is coordinate");
        }
        ProgressLogger progress = new ProgressLogger(Log.getInstance(SamFormatConverter.class));
        for (SAMRecord rec : reader) {
            writer.addAlignment(rec);
            progress.record(rec);
        }
        CloserUtil.close(reader);
        writer.close();
    }
}

