/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina;

import htsjdk.samtools.SAMRecordQueryNameComparator;
import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.fastq.BasicFastqWriter;
import htsjdk.samtools.fastq.FastqReader;
import htsjdk.samtools.fastq.FastqRecord;
import htsjdk.samtools.fastq.FastqWriter;
import htsjdk.samtools.fastq.FastqWriterFactory;
import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.SortingCollection;
import htsjdk.samtools.util.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.BaseCallingProgramGroup;
import picard.fastq.Casava18ReadNameEncoder;
import picard.fastq.IlluminaReadNameEncoder;
import picard.fastq.ReadNameEncoder;
import picard.illumina.BasecallsConverter;
import picard.illumina.IlluminaBasecallsConverter;
import picard.illumina.NewIlluminaBasecallsConverter;
import picard.illumina.parser.ClusterData;
import picard.illumina.parser.IlluminaFileUtil;
import picard.illumina.parser.ReadData;
import picard.illumina.parser.ReadStructure;
import picard.illumina.parser.readers.BclQualityEvaluationStrategy;
import picard.util.IlluminaUtil;
import picard.util.TabbedTextFileWithHeaderParser;

@CommandLineProgramProperties(summary="Generate FASTQ file(s) from Illumina basecall read data.  <p>This tool generates FASTQ files from data in an Illumina BaseCalls output directory.  Separate FASTQ files are created for each template, barcode, and index (molecular barcode) read.  Briefly, the template reads are the target sequence of your experiment, the barcode sequence reads facilitate sample demultiplexing, and the index reads help mitigate instrument phasing errors.  For additional information on the read types, please see the following reference <a href'=http://www.ncbi.nlm.nih.gov/pmc/articles/PMC3245947/'>here</a>.</p><p>In the absence of sample pooling (multiplexing) and/or barcodes, then an OUTPUT_PREFIX (file directory) must be provided as the sample identifier.  For multiplexed samples, a MULTIPLEX_PARAMS file must be specified.  The MULTIPLEX_PARAMS file contains the list of sample barcodes used to sort template, barcode, and index reads.  It is essentially the same as the BARCODE_FILE used in the<a href='http://broadinstitute.github.io/picard/command-line-overview.html#ExtractIlluminaBarcodes'>ExtractIlluminaBarcodes</a> tool.</p>     <p>Files from this tool use the following naming format: {prefix}.{type}_{number}.fastq with the {prefix} indicating the sample barcode, the {type} indicating the types of reads e.g. index, barcode, or blank (if it contains a template read).  The {number} indicates the read number, either first (1) or second (2) for paired-end sequencing. </p> <h4>Usage examples:</h4><pre>Example 1: Sample(s) with either no barcode or barcoded without multiplexing <br />java -jar picard.jar IlluminaBasecallsToFastq \\<br />      READ_STRUCTURE=25T8B25T \\<br />      BASECALLS_DIR=basecallDirectory \\<br />      LANE=001 \\<br />      OUTPUT_PREFIX=noBarcode.1 \\<br />      RUN_BARCODE=run15 \\<br />      FLOWCELL_BARCODE=abcdeACXX <br /><br />Example 2: Multiplexed samples <br />java -jar picard.jar IlluminaBasecallsToFastq \\<br />      READ_STRUCTURE=25T8B25T \\<br />      BASECALLS_DIR=basecallDirectory \\<br />      LANE=001 \\<br />      MULTIPLEX_PARAMS=demultiplexed_output.txt \\<br />      RUN_BARCODE=run15 \\<br />      FLOWCELL_BARCODE=abcdeACXX <br /></pre><p>The FLOWCELL_BARCODE is required if emitting Casava 1.8-style read name headers.</p><hr />", oneLineSummary="Generate FASTQ file(s) from Illumina basecall read data.  ", programGroup=BaseCallingProgramGroup.class)
@DocumentedFeature
public class IlluminaBasecallsToFastq
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Generate FASTQ file(s) from Illumina basecall read data.  ";
    static final String USAGE_DETAILS = "<p>This tool generates FASTQ files from data in an Illumina BaseCalls output directory.  Separate FASTQ files are created for each template, barcode, and index (molecular barcode) read.  Briefly, the template reads are the target sequence of your experiment, the barcode sequence reads facilitate sample demultiplexing, and the index reads help mitigate instrument phasing errors.  For additional information on the read types, please see the following reference <a href'=http://www.ncbi.nlm.nih.gov/pmc/articles/PMC3245947/'>here</a>.</p><p>In the absence of sample pooling (multiplexing) and/or barcodes, then an OUTPUT_PREFIX (file directory) must be provided as the sample identifier.  For multiplexed samples, a MULTIPLEX_PARAMS file must be specified.  The MULTIPLEX_PARAMS file contains the list of sample barcodes used to sort template, barcode, and index reads.  It is essentially the same as the BARCODE_FILE used in the<a href='http://broadinstitute.github.io/picard/command-line-overview.html#ExtractIlluminaBarcodes'>ExtractIlluminaBarcodes</a> tool.</p>     <p>Files from this tool use the following naming format: {prefix}.{type}_{number}.fastq with the {prefix} indicating the sample barcode, the {type} indicating the types of reads e.g. index, barcode, or blank (if it contains a template read).  The {number} indicates the read number, either first (1) or second (2) for paired-end sequencing. </p> <h4>Usage examples:</h4><pre>Example 1: Sample(s) with either no barcode or barcoded without multiplexing <br />java -jar picard.jar IlluminaBasecallsToFastq \\<br />      READ_STRUCTURE=25T8B25T \\<br />      BASECALLS_DIR=basecallDirectory \\<br />      LANE=001 \\<br />      OUTPUT_PREFIX=noBarcode.1 \\<br />      RUN_BARCODE=run15 \\<br />      FLOWCELL_BARCODE=abcdeACXX <br /><br />Example 2: Multiplexed samples <br />java -jar picard.jar IlluminaBasecallsToFastq \\<br />      READ_STRUCTURE=25T8B25T \\<br />      BASECALLS_DIR=basecallDirectory \\<br />      LANE=001 \\<br />      MULTIPLEX_PARAMS=demultiplexed_output.txt \\<br />      RUN_BARCODE=run15 \\<br />      FLOWCELL_BARCODE=abcdeACXX <br /></pre><p>The FLOWCELL_BARCODE is required if emitting Casava 1.8-style read name headers.</p><hr />";
    @Argument(doc="The basecalls directory. ", shortName="B")
    public File BASECALLS_DIR;
    @Argument(doc="The barcodes directory with _barcode.txt files (generated by ExtractIlluminaBarcodes). If not set, use BASECALLS_DIR. ", shortName="BCD", optional=true)
    public File BARCODES_DIR;
    @Argument(doc="Lane number. ", shortName="L")
    public Integer LANE;
    @Argument(doc="The prefix for output FASTQs.  Extensions as described above are appended.  Use this option for a non-barcoded run, or for a barcoded run in which it is not desired to demultiplex reads into separate files by barcode.", shortName="O", mutex={"MULTIPLEX_PARAMS"})
    public File OUTPUT_PREFIX;
    @Argument(doc="The barcode of the run.  Prefixed to read names.")
    public String RUN_BARCODE;
    @Argument(doc="The name of the machine on which the run was sequenced; required if emitting Casava1.8-style read name headers", optional=true)
    public String MACHINE_NAME;
    @Argument(doc="The barcode of the flowcell that was sequenced; required if emitting Casava1.8-style read name headers", optional=true)
    public String FLOWCELL_BARCODE;
    @Argument(doc="A description of the logical structure of clusters in an Illumina Run, i.e. a description of the structure IlluminaBasecallsToSam assumes the  data to be in. It should consist of integer/character pairs describing the number of cycles and the type of those cycles (B for Sample Barcode, M for molecular barcode, T for Template, and S for skip).  E.g. If the input data consists of 80 base clusters and we provide a read structure of \"28T8M8B8S28T\" then the sequence may be split up into four reads:\n* read one with 28 cycles (bases) of template\n* read two with 8 cycles (bases) of molecular barcode (ex. unique molecular barcode)\n* read three with 8 cycles (bases) of sample barcode\n* 8 cycles (bases) skipped.\n* read four with 28 cycles (bases) of template\nThe skipped cycles would NOT be included in an output SAM/BAM file or in read groups therein.", shortName="RS")
    public String READ_STRUCTURE;
    @Argument(doc="Tab-separated file for creating all output FASTQs demultiplexed by barcode for a lane with single IlluminaBasecallsToFastq invocation.  The columns are OUTPUT_PREFIX, and BARCODE_1, BARCODE_2 ... BARCODE_X where X = number of barcodes per cluster (optional).  Row with BARCODE_1 set to 'N' is used to specify an output_prefix for no barcode match.", mutex={"OUTPUT_PREFIX"})
    public File MULTIPLEX_PARAMS;
    @Deprecated
    @Argument(doc="Deprecated (No longer used). Which adapters to look for in the read.", optional=true)
    public List<IlluminaUtil.IlluminaAdapterPair> ADAPTERS_TO_CHECK = null;
    @Argument(doc="The number of threads to run in parallel. If NUM_PROCESSORS = 0, number of cores is automatically set to the number of cores available on the machine. If NUM_PROCESSORS < 0, then the number of cores used will be the number available on the machine less NUM_PROCESSORS.")
    public Integer NUM_PROCESSORS = 0;
    @Argument(doc="If set, this is the first tile to be processed (used for debugging).  Note that tiles are not processed in numerical order.", optional=true)
    public Integer FIRST_TILE;
    @Argument(doc="If set, process no more than this many tiles (used for debugging).", optional=true)
    public Integer TILE_LIMIT;
    @Argument(doc="Apply EAMSS filtering to identify inappropriately quality scored bases towards the ends of reads and convert their quality scores to Q2.")
    public boolean APPLY_EAMSS_FILTER = true;
    @Argument(doc="If true, call System.gc() periodically.  This is useful in cases in which the -Xmx value passed is larger than the available memory.")
    public Boolean FORCE_GC = true;
    @Argument(doc="Configure SortingCollections to store this many records before spilling to disk. For an indexed run, each SortingCollection gets this value/number of indices.")
    public int MAX_READS_IN_RAM_PER_TILE = 1200000;
    @Argument(doc="The minimum quality (after transforming 0s to 1s) expected from reads.  If qualities are lower than this value, an error is thrown.The default of 2 is what the Illumina's spec describes as the minimum, but in practice the value has been observed lower.")
    public int MINIMUM_QUALITY = 2;
    @Argument(doc="Whether to include non-PF reads", shortName="NONPF", optional=true)
    public boolean INCLUDE_NON_PF_READS = true;
    @Argument(doc="Whether to ignore reads whose barcodes are not found in MULTIPLEX_PARAMS.  Useful when outputting FASTQs for only a subset of the barcodes in a lane.", shortName="INGORE_UNEXPECTED")
    public boolean IGNORE_UNEXPECTED_BARCODES = false;
    @Argument(doc="The read name header formatting to emit.  Casava1.8 formatting has additional information beyond Illumina, including: the passing-filter flag value for the read, the flowcell name, and the sequencer name.")
    public ReadNameFormat READ_NAME_FORMAT = ReadNameFormat.CASAVA_1_8;
    @Argument(shortName="GZIP", doc="Compress output FASTQ files using gzip and append a .gz extension to the file names.")
    public boolean COMPRESS_OUTPUTS = false;
    private final Map<String, FastqRecordsWriter> sampleBarcodeFastqWriterMap = new HashMap<String, FastqRecordsWriter>();
    private ReadStructure readStructure;
    private BasecallsConverter<FastqRecordsForCluster> basecallsConverter;
    private static final Log log = Log.getInstance(IlluminaBasecallsToFastq.class);
    private final FastqWriterFactory fastqWriterFactory = new FastqWriterFactory();
    private ReadNameEncoder readNameEncoder;
    private static final Comparator<FastqRecordsForCluster> queryNameComparator = (r1, r2) -> SAMRecordQueryNameComparator.compareReadNames(r1.templateRecords[0].getReadHeader(), r2.templateRecords[0].getReadHeader());

    @Override
    protected int doWork() {
        this.initialize();
        this.basecallsConverter.doTileProcessing();
        return 0;
    }

    @Override
    protected String[] customCommandLineValidation() {
        LinkedList<String> errors = new LinkedList<String>();
        if (this.READ_NAME_FORMAT == ReadNameFormat.CASAVA_1_8 && this.MACHINE_NAME == null) {
            errors.add("MACHINE_NAME is required when using Casava1.8-style read name headers.");
        }
        if (this.READ_NAME_FORMAT == ReadNameFormat.CASAVA_1_8 && this.FLOWCELL_BARCODE == null) {
            errors.add("FLOWCELL_BARCODE is required when using Casava1.8-style read name headers.");
        }
        if (this.ADAPTERS_TO_CHECK != null) {
            log.warn("ADAPTERS_TO_CHECK is not used");
        }
        if (errors.isEmpty()) {
            return null;
        }
        return errors.toArray(new String[errors.size()]);
    }

    private void initialize() {
        boolean demultiplex;
        this.fastqWriterFactory.setCreateMd5(this.CREATE_MD5_FILE);
        switch (this.READ_NAME_FORMAT) {
            case CASAVA_1_8: {
                this.readNameEncoder = new Casava18ReadNameEncoder(this.MACHINE_NAME, this.RUN_BARCODE, this.FLOWCELL_BARCODE);
                break;
            }
            case ILLUMINA: {
                this.readNameEncoder = new IlluminaReadNameEncoder(this.RUN_BARCODE);
            }
        }
        BclQualityEvaluationStrategy bclQualityEvaluationStrategy = new BclQualityEvaluationStrategy(this.MINIMUM_QUALITY);
        this.readStructure = new ReadStructure(this.READ_STRUCTURE);
        if (this.MULTIPLEX_PARAMS != null) {
            IOUtil.assertFileIsReadable(this.MULTIPLEX_PARAMS);
        }
        if (this.OUTPUT_PREFIX != null) {
            this.sampleBarcodeFastqWriterMap.put(null, this.buildWriter(this.OUTPUT_PREFIX));
            demultiplex = false;
        } else {
            this.populateWritersFromMultiplexParams();
            demultiplex = true;
        }
        int readsPerCluster = this.readStructure.templates.length() + this.readStructure.sampleBarcodes.length();
        if (IlluminaFileUtil.hasCbcls(this.BASECALLS_DIR, this.LANE)) {
            if (this.BARCODES_DIR == null) {
                this.BARCODES_DIR = this.BASECALLS_DIR;
            }
            this.basecallsConverter = new NewIlluminaBasecallsConverter<FastqRecordsForCluster>(this.BASECALLS_DIR, this.BARCODES_DIR, this.LANE, this.readStructure, this.sampleBarcodeFastqWriterMap, demultiplex, Math.max(1, this.MAX_READS_IN_RAM_PER_TILE / readsPerCluster), this.TMP_DIR, this.NUM_PROCESSORS, this.FIRST_TILE, this.TILE_LIMIT, queryNameComparator, new FastqRecordsForClusterCodec(this.readStructure.templates.length(), this.readStructure.sampleBarcodes.length(), this.readStructure.molecularBarcode.length()), FastqRecordsForCluster.class, bclQualityEvaluationStrategy, this.IGNORE_UNEXPECTED_BARCODES);
        } else {
            this.basecallsConverter = new IlluminaBasecallsConverter<FastqRecordsForCluster>(this.BASECALLS_DIR, this.BARCODES_DIR, this.LANE, this.readStructure, this.sampleBarcodeFastqWriterMap, demultiplex, Math.max(1, this.MAX_READS_IN_RAM_PER_TILE / readsPerCluster), this.TMP_DIR, this.NUM_PROCESSORS, this.FORCE_GC, this.FIRST_TILE, this.TILE_LIMIT, queryNameComparator, new FastqRecordsForClusterCodec(this.readStructure.templates.length(), this.readStructure.sampleBarcodes.length(), this.readStructure.molecularBarcode.length()), FastqRecordsForCluster.class, bclQualityEvaluationStrategy, this.APPLY_EAMSS_FILTER, this.INCLUDE_NON_PF_READS, this.IGNORE_UNEXPECTED_BARCODES);
        }
        this.basecallsConverter.setConverter(new ClusterToFastqRecordsForClusterConverter(this.basecallsConverter.getFactory().getOutputReadStructure()));
        log.info("READ STRUCTURE IS " + this.readStructure.toString());
    }

    private void assertExpectedColumns(Set<String> actualCols, Set<String> expectedCols) {
        HashSet<String> missingColumns = new HashSet<String>(expectedCols);
        missingColumns.removeAll(actualCols);
        if (!missingColumns.isEmpty()) {
            throw new PicardException(String.format("MULTIPLEX_PARAMS file %s is missing the following columns: %s.", this.MULTIPLEX_PARAMS.getAbsolutePath(), StringUtil.join(", ", missingColumns)));
        }
    }

    private void populateWritersFromMultiplexParams() {
        TabbedTextFileWithHeaderParser libraryParamsParser = new TabbedTextFileWithHeaderParser(this.MULTIPLEX_PARAMS);
        Set<String> expectedColumnLabels = CollectionUtil.makeSet("OUTPUT_PREFIX");
        ArrayList<String> sampleBarcodeColumnLabels = new ArrayList<String>();
        for (int i = 1; i <= this.readStructure.sampleBarcodes.length(); ++i) {
            sampleBarcodeColumnLabels.add("BARCODE_" + i);
        }
        expectedColumnLabels.addAll(sampleBarcodeColumnLabels);
        this.assertExpectedColumns(libraryParamsParser.columnLabels(), expectedColumnLabels);
        for (TabbedTextFileWithHeaderParser.Row row : libraryParamsParser) {
            String key;
            ArrayList<String> sampleBarcodeValues = null;
            if (!sampleBarcodeColumnLabels.isEmpty()) {
                sampleBarcodeValues = new ArrayList<String>();
                for (String sampleBarcodeLabel : sampleBarcodeColumnLabels) {
                    sampleBarcodeValues.add(row.getField(sampleBarcodeLabel));
                }
            }
            String string = key = sampleBarcodeValues == null || sampleBarcodeValues.contains("N") ? null : StringUtil.join("", sampleBarcodeValues);
            if (this.sampleBarcodeFastqWriterMap.containsKey(key)) {
                throw new PicardException("Row for barcode " + key + " appears more than once in MULTIPLEX_PARAMS file " + this.MULTIPLEX_PARAMS);
            }
            FastqRecordsWriter writer = this.buildWriter(new File(row.getField("OUTPUT_PREFIX")));
            this.sampleBarcodeFastqWriterMap.put(key, writer);
        }
        if (this.sampleBarcodeFastqWriterMap.isEmpty()) {
            throw new PicardException("MULTIPLEX_PARAMS file " + this.MULTIPLEX_PARAMS + " does have any data rows.");
        }
        libraryParamsParser.close();
    }

    private FastqRecordsWriter buildWriter(File outputPrefix) {
        String filename;
        int i;
        File outputDir = outputPrefix.getAbsoluteFile().getParentFile();
        IOUtil.assertDirectoryIsWritable(outputDir);
        String prefixString = outputPrefix.getName();
        String suffixString = this.COMPRESS_OUTPUTS ? "fastq.gz" : "fastq";
        FastqWriter[] templateWriters = new FastqWriter[this.readStructure.templates.length()];
        FastqWriter[] sampleBarcodeWriters = new FastqWriter[this.readStructure.sampleBarcodes.length()];
        FastqWriter[] molecularBarcodeWriters = new FastqWriter[this.readStructure.molecularBarcode.length()];
        for (i = 0; i < templateWriters.length; ++i) {
            filename = String.format("%s.%d.%s", prefixString, i + 1, suffixString);
            templateWriters[i] = this.fastqWriterFactory.newWriter(new File(outputDir, filename));
        }
        for (i = 0; i < sampleBarcodeWriters.length; ++i) {
            filename = String.format("%s.barcode_%d.%s", prefixString, i + 1, suffixString);
            sampleBarcodeWriters[i] = this.fastqWriterFactory.newWriter(new File(outputDir, filename));
        }
        for (i = 0; i < molecularBarcodeWriters.length; ++i) {
            filename = String.format("%s.index_%d.%s", prefixString, i + 1, suffixString);
            molecularBarcodeWriters[i] = this.fastqWriterFactory.newWriter(new File(outputDir, filename));
        }
        return new FastqRecordsWriter(templateWriters, sampleBarcodeWriters, molecularBarcodeWriters);
    }

    static class FastqRecordsForClusterCodec
    implements SortingCollection.Codec<FastqRecordsForCluster> {
        private final int numTemplates;
        private final int numSampleBarcodes;
        private final int numMolecularBarcodes;
        private BasicFastqWriter writer = null;
        private FastqReader reader = null;

        FastqRecordsForClusterCodec(int numTemplates, int numSampleBarcodes, int numMolecularBarcodes) {
            this.numTemplates = numTemplates;
            this.numSampleBarcodes = numSampleBarcodes;
            this.numMolecularBarcodes = numMolecularBarcodes;
        }

        @Override
        public void setOutputStream(OutputStream os) {
            this.writer = new BasicFastqWriter(new PrintStream(os));
        }

        @Override
        public void setInputStream(InputStream is) {
            this.reader = new FastqReader(new BufferedReader(new InputStreamReader(is)));
        }

        @Override
        public void encode(FastqRecordsForCluster val) {
            if (this.numTemplates != val.templateRecords.length) {
                throw new IllegalStateException();
            }
            if (this.numSampleBarcodes != val.sampleBarcodeRecords.length) {
                throw new IllegalStateException();
            }
            this.encodeArray(val.templateRecords);
            this.encodeArray(val.sampleBarcodeRecords);
            this.encodeArray(val.molecularBarcodeRecords);
            this.writer.flush();
        }

        private void encodeArray(FastqRecord[] recs) {
            for (FastqRecord rec : recs) {
                this.writer.write(rec);
            }
        }

        @Override
        public FastqRecordsForCluster decode() {
            if (!this.reader.hasNext()) {
                return null;
            }
            FastqRecordsForCluster ret = new FastqRecordsForCluster(this.numTemplates, this.numSampleBarcodes, this.numMolecularBarcodes);
            this.decodeArray(ret.templateRecords);
            this.decodeArray(ret.sampleBarcodeRecords);
            this.decodeArray(ret.molecularBarcodeRecords);
            return ret;
        }

        private void decodeArray(FastqRecord[] recs) {
            for (int i = 0; i < recs.length; ++i) {
                recs[i] = this.reader.next();
            }
        }

        @Override
        public SortingCollection.Codec<FastqRecordsForCluster> clone() {
            return new FastqRecordsForClusterCodec(this.numTemplates, this.numSampleBarcodes, this.numMolecularBarcodes);
        }
    }

    class ClusterToFastqRecordsForClusterConverter
    implements BasecallsConverter.ClusterDataConverter<FastqRecordsForCluster> {
        private final int[] templateIndices;
        private final int[] sampleBarcodeIndicies;
        private final int[] molecularBarcodeIndicies;

        ClusterToFastqRecordsForClusterConverter(ReadStructure outputReadStructure) {
            this.templateIndices = outputReadStructure.templates.getIndices();
            this.sampleBarcodeIndicies = outputReadStructure.sampleBarcodes.getIndices();
            this.molecularBarcodeIndicies = outputReadStructure.molecularBarcode.getIndices();
        }

        @Override
        public FastqRecordsForCluster convertClusterToOutputRecord(ClusterData cluster) {
            FastqRecordsForCluster ret = new FastqRecordsForCluster(((IlluminaBasecallsToFastq)IlluminaBasecallsToFastq.this).readStructure.templates.length(), ((IlluminaBasecallsToFastq)IlluminaBasecallsToFastq.this).readStructure.sampleBarcodes.length(), ((IlluminaBasecallsToFastq)IlluminaBasecallsToFastq.this).readStructure.molecularBarcode.length());
            boolean appendTemplateNumberSuffix = ret.templateRecords.length > 1;
            boolean appendMolecularBarcodeNumber = ret.molecularBarcodeRecords.length > 1;
            this.makeFastqRecords(ret.templateRecords, this.templateIndices, cluster, appendTemplateNumberSuffix);
            this.makeFastqRecords(ret.sampleBarcodeRecords, this.sampleBarcodeIndicies, cluster, false);
            this.makeFastqRecords(ret.molecularBarcodeRecords, this.molecularBarcodeIndicies, cluster, appendMolecularBarcodeNumber);
            return ret;
        }

        private void makeFastqRecords(FastqRecord[] recs, int[] indices, ClusterData cluster, boolean appendReadNumberSuffix) {
            for (int i = 0; i < indices.length; i = (int)((short)(i + 1))) {
                ReadData readData = cluster.getRead(indices[i]);
                String readBases = StringUtil.bytesToString(readData.getBases()).replace('.', 'N');
                String readName = IlluminaBasecallsToFastq.this.readNameEncoder.generateReadName(cluster, appendReadNumberSuffix ? Integer.valueOf(i + 1) : null);
                recs[i] = new FastqRecord(readName, readBases, null, SAMUtils.phredToFastq(readData.getQualities()));
            }
        }
    }

    static class FastqRecordsForCluster {
        final FastqRecord[] templateRecords;
        final FastqRecord[] sampleBarcodeRecords;
        final FastqRecord[] molecularBarcodeRecords;

        FastqRecordsForCluster(int numTemplates, int numSampleBarcodes, int numMolecularBarcodes) {
            this.templateRecords = new FastqRecord[numTemplates];
            this.sampleBarcodeRecords = new FastqRecord[numSampleBarcodes];
            this.molecularBarcodeRecords = new FastqRecord[numMolecularBarcodes];
        }
    }

    private static final class FastqRecordsWriter
    implements BasecallsConverter.ConvertedClusterDataWriter<FastqRecordsForCluster> {
        final FastqWriter[] templateWriters;
        final FastqWriter[] sampleBarcodeWriters;
        final FastqWriter[] molecularBarcodeWriters;

        private FastqRecordsWriter(FastqWriter[] templateWriters, FastqWriter[] sampleBarcodeWriters, FastqWriter[] molecularBarcodeWriters) {
            this.templateWriters = templateWriters;
            this.sampleBarcodeWriters = sampleBarcodeWriters;
            this.molecularBarcodeWriters = molecularBarcodeWriters;
        }

        @Override
        public void write(FastqRecordsForCluster records) {
            this.write(this.templateWriters, records.templateRecords);
            this.write(this.sampleBarcodeWriters, records.sampleBarcodeRecords);
            this.write(this.molecularBarcodeWriters, records.molecularBarcodeRecords);
        }

        private void write(FastqWriter[] writers, FastqRecord[] records) {
            for (int i = 0; i < writers.length; ++i) {
                writers[i].write(records[i]);
            }
        }

        @Override
        public void close() {
            for (FastqWriter writer : this.templateWriters) {
                writer.close();
            }
            for (FastqWriter writer : this.sampleBarcodeWriters) {
                writer.close();
            }
            for (FastqWriter writer : this.molecularBarcodeWriters) {
                writer.close();
            }
        }
    }

    public static enum ReadNameFormat {
        CASAVA_1_8,
        ILLUMINA;

    }
}

