/*
 * Decompiled with CFR 0.152.
 */
package picard.fingerprint;

import java.nio.file.Path;
import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;
import picard.fingerprint.LocusResult;

public class MatchResults
implements Comparable<MatchResults> {
    private final Path fingerprintFile;
    private final String sample;
    private final double sampleLikelihood;
    private final double populationLikelihood;
    private final double LOD;
    private final double lodTN;
    private final double lodNT;
    private final SortedSet<LocusResult> locusResults;

    public double getLodNT() {
        return this.lodNT;
    }

    public double getLodTN() {
        return this.lodTN;
    }

    MatchResults(Path fingerprintFile, String sample, double sampleLikelihood, double populationLikelihood, double lodTN, double lodNT, Collection<LocusResult> locusResults) {
        this.fingerprintFile = fingerprintFile;
        this.sample = sample;
        this.sampleLikelihood = sampleLikelihood;
        this.populationLikelihood = populationLikelihood;
        this.LOD = sampleLikelihood - populationLikelihood;
        this.lodTN = lodTN;
        this.lodNT = lodNT;
        this.locusResults = locusResults != null ? new TreeSet<LocusResult>(locusResults) : null;
    }

    @Override
    public int compareTo(MatchResults that) {
        if (this.LOD != that.LOD) {
            return this.LOD > that.LOD ? -1 : 1;
        }
        return this.sample.compareTo(that.sample);
    }

    public String getSample() {
        return this.sample;
    }

    public double getSampleLikelihood() {
        return this.sampleLikelihood;
    }

    public double getPopulationLikelihood() {
        return this.populationLikelihood;
    }

    public double getLOD() {
        return this.LOD;
    }

    public SortedSet<LocusResult> getLocusResults() {
        return this.locusResults;
    }

    public Path getFingerprintFile() {
        return this.fingerprintFile;
    }
}

