/*
 * Decompiled with CFR 0.152.
 */
package picard.fingerprint;

import picard.fingerprint.HaplotypeProbabilities;
import picard.fingerprint.Snp;

public class HaplotypeProbabilityOfNormalGivenTumor
extends HaplotypeProbabilities {
    private final HaplotypeProbabilities hpOfTumor;
    private final TransitionMatrixGenerator transitionMatrix;

    public HaplotypeProbabilityOfNormalGivenTumor(HaplotypeProbabilityOfNormalGivenTumor other) {
        super(other.getHaplotype());
        this.transitionMatrix = other.transitionMatrix;
        this.hpOfTumor = other.hpOfTumor.deepCopy();
    }

    public HaplotypeProbabilityOfNormalGivenTumor(HaplotypeProbabilities hpOfTumor, double pLoH) {
        super(hpOfTumor.getHaplotype());
        this.hpOfTumor = hpOfTumor;
        this.transitionMatrix = new TransitionMatrixGenerator(pLoH);
    }

    @Override
    public double[] getLikelihoods() {
        double[] normalHaplotypeLikelihoods = new double[3];
        double[] tumorHaplotypeLikelihoods = this.hpOfTumor.getLikelihoods();
        for (HaplotypeProbabilities.Genotype g_n : HaplotypeProbabilities.Genotype.values()) {
            normalHaplotypeLikelihoods[g_n.v] = 0.0;
            for (HaplotypeProbabilities.Genotype g_t : HaplotypeProbabilities.Genotype.values()) {
                int n = g_n.v;
                normalHaplotypeLikelihoods[n] = normalHaplotypeLikelihoods[n] + tumorHaplotypeLikelihoods[g_t.v] * this.transitionMatrix.get()[g_n.v][g_t.v];
            }
        }
        return normalHaplotypeLikelihoods;
    }

    @Override
    public Snp getRepresentativeSnp() {
        return this.hpOfTumor.getRepresentativeSnp();
    }

    @Override
    public HaplotypeProbabilityOfNormalGivenTumor merge(HaplotypeProbabilities other) {
        if (!this.getHaplotype().equals(other.getHaplotype())) {
            throw new IllegalArgumentException("Mismatched haplotypes in call to HaplotypeProbabilities.merge(): " + this.getHaplotype() + ", " + other.getHaplotype());
        }
        if (!(other instanceof HaplotypeProbabilityOfNormalGivenTumor)) {
            throw new IllegalArgumentException("Can only merge HaplotypeProbabilities of same class.");
        }
        this.hpOfTumor.merge(((HaplotypeProbabilityOfNormalGivenTumor)other).hpOfTumor);
        return this;
    }

    @Override
    public HaplotypeProbabilityOfNormalGivenTumor deepCopy() {
        return new HaplotypeProbabilityOfNormalGivenTumor(this);
    }

    @Override
    public int getObsAllele1() {
        return this.hpOfTumor.getObsAllele1();
    }

    @Override
    public int getObsAllele2() {
        return this.hpOfTumor.getObsAllele2();
    }

    @Override
    public int getTotalObs() {
        return this.hpOfTumor.getTotalObs();
    }

    @Override
    public boolean hasEvidence() {
        return this.hpOfTumor.hasEvidence();
    }

    private static class TransitionMatrixGenerator {
        private final double[][] transitionMatrix;

        TransitionMatrixGenerator(double pLoH) {
            this.transitionMatrix = new double[][]{{1.0, 0.0, 0.0}, {pLoH / 2.0, 1.0 - pLoH, pLoH / 2.0}, {0.0, 0.0, 1.0}};
        }

        double[][] get() {
            return this.transitionMatrix;
        }
    }
}

