/*
 * Decompiled with CFR 0.152.
 */
package picard.fingerprint;

import com.google.cloud.storage.contrib.nio.SeekableByteChannelPrefetcher;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.filter.SamRecordFilter;
import htsjdk.samtools.filter.SecondaryAlignmentFilter;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.SamLocusIterator;
import htsjdk.samtools.util.SequenceUtil;
import htsjdk.samtools.util.StringUtil;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypeLikelihoods;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFFileReader;
import java.io.File;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.OptionalInt;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import picard.PicardException;
import picard.fingerprint.CheckFingerprint;
import picard.fingerprint.CrosscheckMetric;
import picard.fingerprint.DiploidGenotype;
import picard.fingerprint.Fingerprint;
import picard.fingerprint.FingerprintIdDetails;
import picard.fingerprint.FingerprintResults;
import picard.fingerprint.HaplotypeBlock;
import picard.fingerprint.HaplotypeMap;
import picard.fingerprint.HaplotypeProbabilities;
import picard.fingerprint.HaplotypeProbabilitiesFromContaminatorSequence;
import picard.fingerprint.HaplotypeProbabilitiesFromGenotype;
import picard.fingerprint.HaplotypeProbabilitiesFromGenotypeLikelihoods;
import picard.fingerprint.HaplotypeProbabilitiesFromSequence;
import picard.fingerprint.HaplotypeProbabilityOfNormalGivenTumor;
import picard.fingerprint.LocusResult;
import picard.fingerprint.MatchResults;
import picard.fingerprint.Snp;
import picard.util.AlleleSubsettingUtils;
import picard.util.MathUtil;
import picard.util.ThreadPoolExecutorWithExceptions;

public class FingerprintChecker {
    public static final double DEFAULT_GENOTYPING_ERROR_RATE = 0.01;
    public static final int DEFAULT_MINIMUM_MAPPING_QUALITY = 10;
    public static final int DEFAULT_MINIMUM_BASE_QUALITY = 20;
    private static final Random random = new Random(42L);
    private final HaplotypeMap haplotypes;
    private int minimumBaseQuality = 20;
    private int minimumMappingQuality = 10;
    private double genotypingErrorRate = 0.01;
    private File referenceFasta;
    private ValidationStringency validationStringency = ValidationStringency.DEFAULT_STRINGENCY;
    private boolean allowDuplicateReads = false;
    private double pLossofHet = 0.0;
    private int locusMaxReads = 0;
    private String defaultSampleID = "<UNKNOWN>";
    private final Set<Path> missingRGFiles = new HashSet<Path>();
    private final Log log = Log.getInstance(FingerprintChecker.class);
    private static final Function<SeekableByteChannel, SeekableByteChannel> seekableChannelFunction = chan -> {
        try {
            return SeekableByteChannelPrefetcher.addPrefetcher((int)1, (SeekableByteChannel)chan);
        }
        catch (IOException e) {
            throw new RuntimeException("Trouble wrapping seekable stream with prefetcher.", e);
        }
    };

    public ValidationStringency getValidationStringency() {
        return this.validationStringency;
    }

    public void setValidationStringency(ValidationStringency validationStringency) {
        this.validationStringency = validationStringency;
    }

    public File getReferenceFasta() {
        return this.referenceFasta;
    }

    public FingerprintChecker(File haplotypeData) {
        this.haplotypes = new HaplotypeMap(haplotypeData);
    }

    public FingerprintChecker(HaplotypeMap haplotypes) {
        this.haplotypes = haplotypes;
    }

    public void setMinimumBaseQuality(int minimumBaseQuality) {
        this.minimumBaseQuality = minimumBaseQuality;
    }

    public void setMinimumMappingQuality(int minimumMappingQuality) {
        this.minimumMappingQuality = minimumMappingQuality;
    }

    public void setGenotypingErrorRate(double genotypingErrorRate) {
        this.genotypingErrorRate = genotypingErrorRate;
    }

    public SAMFileHeader getHeader() {
        return this.haplotypes.getHeader();
    }

    public void setAllowDuplicateReads(boolean allowDuplicateReads) {
        this.allowDuplicateReads = allowDuplicateReads;
    }

    public void setpLossofHet(double pLossofHet) {
        this.pLossofHet = pLossofHet;
    }

    public Map<String, Fingerprint> loadFingerprints(Path fingerprintFile, String specificSample) {
        Map<String, Fingerprint> fingerprints;
        VCFFileReader reader = new VCFFileReader(fingerprintFile, false);
        this.checkDictionaryGoodForFingerprinting(reader.getFileHeader().getSequenceDictionary());
        if (reader.isQueryable()) {
            fingerprints = this.loadFingerprintsFromQueriableReader(reader, specificSample, fingerprintFile);
        } else {
            this.log.warn("Couldn't find index for file " + fingerprintFile + " going to read through it all.");
            fingerprints = this.loadFingerprintsFromVariantContexts(reader, specificSample, fingerprintFile);
        }
        reader.getFileHeader().getGenotypeSamples().forEach(sample -> fingerprints.computeIfAbsent((String)sample, s -> new Fingerprint((String)s, fingerprintFile, null)));
        return fingerprints;
    }

    private void checkDictionaryGoodForFingerprinting(SAMSequenceDictionary sequenceDictionaryToCheck) {
        SAMSequenceDictionary activeDictionary = FingerprintChecker.getActiveDictionary(this.haplotypes);
        if (sequenceDictionaryToCheck.getSequences().size() < activeDictionary.size()) {
            throw new IllegalArgumentException("Dictionary on fingerprinted file smaller than that on Haplotype Database!");
        }
        SequenceUtil.assertSequenceDictionariesEqual(activeDictionary, sequenceDictionaryToCheck, true);
    }

    private static SAMSequenceDictionary getActiveDictionary(HaplotypeMap haplotypes) {
        SAMSequenceDictionary origSequenceDictionary = haplotypes.getHeader().getSequenceDictionary();
        OptionalInt maxSequenceIndex = haplotypes.getAllSnps().stream().map(Snp::getChrom).mapToInt(origSequenceDictionary::getSequenceIndex).max();
        if (!maxSequenceIndex.isPresent()) {
            return origSequenceDictionary;
        }
        return new SAMSequenceDictionary(origSequenceDictionary.getSequences().subList(0, maxSequenceIndex.getAsInt() + 1));
    }

    public Map<String, Fingerprint> loadFingerprintsFromNonIndexedVcf(Path fingerprintFile, String specificSample) {
        VCFFileReader reader = new VCFFileReader(fingerprintFile, false);
        this.checkDictionaryGoodForFingerprinting(reader.getFileHeader().getSequenceDictionary());
        return this.loadFingerprintsFromVariantContexts(reader, specificSample, fingerprintFile);
    }

    public Map<String, Fingerprint> loadFingerprintsFromVariantContexts(Iterable<VariantContext> iterable, String specificSample, Path source) {
        HashMap<String, Fingerprint> fingerprints = new HashMap<String, Fingerprint>();
        Set<String> samples = null;
        for (VariantContext ctx : iterable) {
            if (ctx == null) continue;
            if (samples == null) {
                if (specificSample != null) {
                    samples = new HashSet<String>();
                    samples.add(specificSample);
                } else {
                    samples = ctx.getSampleNames();
                    if (samples == null) {
                        this.log.warn("No samples found in file: " + source.toUri().toString() + ". Skipping.");
                        return Collections.emptyMap();
                    }
                }
                samples.forEach(s -> fingerprints.put((String)s, new Fingerprint((String)s, source, null)));
            }
            try {
                this.getFingerprintFromVc(fingerprints, ctx);
            }
            catch (IllegalArgumentException e) {
                this.log.warn(e, "There was a genotyping error in File: " + source.toUri().toString() + "\n" + e.getMessage());
            }
        }
        return fingerprints;
    }

    public Map<String, Fingerprint> loadFingerprintsFromIndexedVcf(Path fingerprintFile, String specificSample) {
        VCFFileReader reader = new VCFFileReader(fingerprintFile, true);
        return this.loadFingerprintsFromQueriableReader(reader, specificSample, fingerprintFile);
    }

    public Map<String, Fingerprint> loadFingerprintsFromQueriableReader(VCFFileReader reader, String specificSample, Path source) {
        this.checkDictionaryGoodForFingerprinting(reader.getFileHeader().getSequenceDictionary());
        TreeSet<Snp> snps = new TreeSet<Snp>(this.haplotypes.getAllSnps());
        return this.loadFingerprintsFromVariantContexts(() -> snps.stream().map(snp -> {
            try {
                return (VariantContext)reader.query(snp.getChrom(), snp.getPos(), snp.getPos()).next();
            }
            catch (NoSuchElementException e) {
                return null;
            }
        }).iterator(), specificSample, source);
    }

    private void getFingerprintFromVc(Map<String, Fingerprint> fingerprints, VariantContext ctx) throws IllegalArgumentException {
        HaplotypeBlock h = this.haplotypes.getHaplotype(ctx.getContig(), ctx.getStart());
        if (h == null) {
            return;
        }
        Snp snp = this.haplotypes.getSnp(ctx.getContig(), ctx.getStart());
        VariantContext usableSnp = AlleleSubsettingUtils.subsetVCToMatchSnp(ctx, snp);
        if (usableSnp == null) {
            return;
        }
        boolean allelesOk = true;
        for (Allele allele : usableSnp.getAlleles()) {
            byte[] bases = allele.getBases();
            if (bases.length <= 1 && (bases[0] == snp.getAllele1() || bases[0] == snp.getAllele2())) continue;
            allelesOk = false;
        }
        if (!allelesOk) {
            this.log.warn("Problem with genotype file: Alleles " + usableSnp.getAlleles() + " do not match to alleles for SNP " + snp + " with alleles " + snp.getAlleleString());
            throw new IllegalArgumentException("Alleles do not match between database and file");
        }
        for (String sample : fingerprints.keySet()) {
            Fingerprint fp = fingerprints.get(sample);
            Genotype genotype = usableSnp.getGenotype(sample);
            if (genotype == null) {
                throw new IllegalArgumentException("Cannot find sample " + sample + " in provided file. ");
            }
            if (genotype.hasPL()) {
                HaplotypeProbabilitiesFromGenotypeLikelihoods hFp = new HaplotypeProbabilitiesFromGenotypeLikelihoods(h);
                hFp.addToLogLikelihoods(snp, usableSnp.getAlleles(), GenotypeLikelihoods.fromPLs(genotype.getPL()).getAsVector());
                fp.add(hFp);
                continue;
            }
            if (genotype.isNoCall() || fp.containsKey(h)) continue;
            boolean hom = genotype.isHom();
            byte allele = StringUtil.toUpperCase(genotype.getAllele(0).getBases()[0]);
            double halfError = this.genotypingErrorRate / 2.0;
            double accuracy = 1.0 - this.genotypingErrorRate;
            double[] probs = new double[]{hom && allele == snp.getAllele1() ? accuracy : halfError, !hom ? accuracy : halfError, hom && allele == snp.getAllele2() ? accuracy : halfError};
            fp.add(new HaplotypeProbabilitiesFromGenotype(snp, h, probs[0], probs[1], probs[2]));
        }
    }

    public IntervalList getLociToGenotype(Collection<Fingerprint> fingerprints) {
        IntervalList intervals = new IntervalList(this.haplotypes.getHeader());
        for (Fingerprint fp : fingerprints) {
            for (HaplotypeProbabilities genotype : fp.values()) {
                HaplotypeBlock h = genotype.getHaplotype();
                for (Snp snp : h.getSnps()) {
                    intervals.add(new Interval(snp.getChrom(), snp.getPos(), snp.getPos(), false, snp.getName()));
                }
            }
        }
        return intervals.uniqued();
    }

    public Map<FingerprintIdDetails, Fingerprint> fingerprintVcf(Path vcfFile) {
        HashMap<FingerprintIdDetails, Fingerprint> fpIdMap = new HashMap<FingerprintIdDetails, Fingerprint>();
        Map<String, Fingerprint> sampleFpMap = this.loadFingerprints(vcfFile, null);
        sampleFpMap.forEach((key, value) -> {
            FingerprintIdDetails fpId = new FingerprintIdDetails();
            fpId.sample = key;
            fpId.file = vcfFile.toUri().toString();
            fpIdMap.put(fpId, (Fingerprint)value);
        });
        return fpIdMap;
    }

    @Deprecated
    public Map<FingerprintIdDetails, Fingerprint> fingerprintSamFile(Path samFile, IntervalList loci) {
        return this.fingerprintSamFile(samFile, HaplotypeProbabilitiesFromSequence::new);
    }

    public Map<FingerprintIdDetails, Fingerprint> fingerprintSamFile(Path samFile, Function<HaplotypeBlock, HaplotypeProbabilities> blockToProbMapper) {
        SamReader in = SamReaderFactory.makeDefault().enable(SamReaderFactory.Option.CACHE_FILE_BASED_INDEXES).referenceSequence(this.referenceFasta).open(samFile, null, seekableChannelFunction);
        this.checkDictionaryGoodForFingerprinting(in.getFileHeader().getSequenceDictionary());
        SamLocusIterator iterator = new SamLocusIterator(in, this.haplotypes.getIntervalList(), in.hasIndex());
        iterator.setEmitUncoveredLoci(true);
        iterator.setMappingQualityScoreCutoff(this.minimumMappingQuality);
        iterator.setQualityScoreCutoff(this.minimumBaseQuality);
        if (this.allowDuplicateReads) {
            ArrayList<SamRecordFilter> filters = new ArrayList<SamRecordFilter>(1);
            filters.add(new SecondaryAlignmentFilter());
            iterator.setSamFilters(filters);
        }
        HashMap<SAMReadGroupRecord, FingerprintIdDetails> fingerprintIdDetailsMap = new HashMap<SAMReadGroupRecord, FingerprintIdDetails>();
        HashMap<FingerprintIdDetails, Fingerprint> fingerprintsByReadGroup = new HashMap<FingerprintIdDetails, Fingerprint>();
        for (SAMReadGroupRecord rg : in.getFileHeader().getReadGroups()) {
            FingerprintIdDetails id = new FingerprintIdDetails(rg.getPlatformUnit(), samFile.toUri().toString());
            id.library = rg.getLibrary();
            id.sample = rg.getSample();
            fingerprintIdDetailsMap.put(rg, id);
            Fingerprint fingerprint = new Fingerprint(id.sample, samFile, id.platformUnit);
            fingerprintsByReadGroup.put(id, fingerprint);
            for (HaplotypeBlock h : this.haplotypes.getHaplotypes()) {
                fingerprint.add(blockToProbMapper.apply(h));
            }
        }
        HashSet<String> usedReadNames = new HashSet<String>(10000);
        for (SamLocusIterator.LocusInfo info : iterator) {
            this.log.debug(() -> "At locus " + info);
            HaplotypeBlock haplotypeBlock = this.haplotypes.getHaplotype(info.getSequenceName(), info.getPosition());
            Snp snp = this.haplotypes.getSnp(info.getSequenceName(), info.getPosition());
            List recordAndOffsetList = this.locusMaxReads == 0 ? info.getRecordAndOffsets() : MathUtil.randomSublist(info.getRecordAndOffsets(), this.locusMaxReads, random);
            for (SamLocusIterator.RecordAndOffset rec : recordAndOffsetList) {
                SAMReadGroupRecord rg = rec.getRecord().getReadGroup();
                if (rg == null && !fingerprintIdDetailsMap.containsKey(null)) {
                    FingerprintIdDetails unknownFPDetails = this.createUnknownFP(samFile, rec.getRecord());
                    fingerprintIdDetailsMap.put(null, unknownFPDetails);
                    Fingerprint fp = new Fingerprint(unknownFPDetails.sample, samFile, unknownFPDetails.platformUnit);
                    fingerprintsByReadGroup.put(unknownFPDetails, fp);
                    for (HaplotypeBlock h : this.haplotypes.getHaplotypes()) {
                        fp.add(blockToProbMapper.apply(h));
                    }
                }
                if (fingerprintIdDetailsMap.containsKey(rg)) {
                    FingerprintIdDetails details = (FingerprintIdDetails)fingerprintIdDetailsMap.get(rg);
                    String readName = rec.getRecord().getReadName();
                    if (usedReadNames.contains(readName)) continue;
                    HaplotypeProbabilitiesFromSequence probs = (HaplotypeProbabilitiesFromSequence)((Fingerprint)fingerprintsByReadGroup.get(details)).get(haplotypeBlock);
                    byte base = StringUtil.toUpperCase(rec.getReadBase());
                    byte qual = rec.getBaseQuality();
                    probs.addToProbs(snp, base, qual);
                    usedReadNames.add(readName);
                    continue;
                }
                PicardException e = new PicardException("Unknown read group: " + rg + " in file: " + samFile);
                this.log.error(e, new Object[0]);
                throw e;
            }
        }
        return fingerprintsByReadGroup;
    }

    private FingerprintIdDetails createUnknownFP(Path samFile, SAMRecord rec) {
        PicardException e = new PicardException("Found read with no readgroup: " + rec.getReadName() + " in file: " + samFile);
        if (this.validationStringency != ValidationStringency.STRICT) {
            SAMReadGroupRecord readGroupRecord = new SAMReadGroupRecord("<UNKNOWN>:::" + samFile.toUri().toString());
            readGroupRecord.setLibrary("<UNKNOWN>");
            readGroupRecord.setSample(this.defaultSampleID);
            readGroupRecord.setPlatformUnit("<UNKNOWN>.0.ZZZ");
            if (this.validationStringency != ValidationStringency.SILENT && this.missingRGFiles.add(samFile)) {
                this.log.warn(e.getMessage());
                this.log.warn("further messages from this file will be suppressed");
            }
            return new FingerprintIdDetails(readGroupRecord, samFile.toUri().toString());
        }
        this.log.error(e.getMessage());
        throw e;
    }

    public Map<String, Fingerprint> identifyContaminant(Path samFile, double contamination) {
        Map<FingerprintIdDetails, Fingerprint> fpIdDetailsMap = this.fingerprintSamFile(samFile, (HaplotypeBlock h) -> new HaplotypeProbabilitiesFromContaminatorSequence((HaplotypeBlock)h, contamination));
        Map<FingerprintIdDetails, Fingerprint> fpIdDetailsBySample = Fingerprint.mergeFingerprintsBy(fpIdDetailsMap, Fingerprint.getFingerprintIdDetailsStringFunction(CrosscheckMetric.DataType.SAMPLE));
        return fpIdDetailsBySample.entrySet().stream().collect(Collectors.toMap(e -> ((FingerprintIdDetails)e.getKey()).sample, Map.Entry::getValue));
    }

    public Map<FingerprintIdDetails, Fingerprint> fingerprintFiles(Collection<Path> files, int threads, int waitTime, TimeUnit waitTimeUnit) {
        AtomicInteger filesRead = new AtomicInteger(0);
        ThreadPoolExecutorWithExceptions executor = new ThreadPoolExecutorWithExceptions(threads);
        ExecutorCompletionService<Path> executorCompletionService = new ExecutorCompletionService<Path>(executor);
        ConcurrentHashMap<FingerprintIdDetails, Fingerprint> retval = new ConcurrentHashMap<FingerprintIdDetails, Fingerprint>(files.size());
        for (Path p : files) {
            executorCompletionService.submit(() -> {
                Map<FingerprintIdDetails, Fingerprint> oneFileFingerprints = CheckFingerprint.fileContainsReads(p) ? this.fingerprintSamFile(p, HaplotypeProbabilitiesFromSequence::new) : this.fingerprintVcf(p);
                if (oneFileFingerprints.isEmpty()) {
                    this.log.warn("No fingerprint data was found in file:" + p);
                }
                retval.putAll(oneFileFingerprints);
                this.log.debug("Processed file: " + p.toUri().toString() + " (" + filesRead.get() + ")");
                if (filesRead.incrementAndGet() % 100 == 0) {
                    this.log.info("Processed " + filesRead.get() + " out of " + files.size());
                }
            }, p);
        }
        executor.shutdown();
        try {
            executor.awaitTermination(waitTime, waitTimeUnit);
        }
        catch (InterruptedException ie) {
            throw new PicardException("Interrupted while waiting for executor to terminate.", ie);
        }
        for (int i = 0; i < files.size(); ++i) {
            try {
                executorCompletionService.take().get();
                continue;
            }
            catch (InterruptedException | ExecutionException e) {
                throw new PicardException("Failed to fingerprint", e);
            }
        }
        this.log.info("Processed files. " + retval.size() + " fingerprints found in map.");
        return retval;
    }

    public List<FingerprintResults> checkFingerprints(List<Path> samFiles, List<Path> genotypeFiles, String specificSample, boolean ignoreReadGroups) {
        LinkedList<Fingerprint> expectedFingerprints = new LinkedList<Fingerprint>();
        for (Path p : genotypeFiles) {
            expectedFingerprints.addAll(this.loadFingerprints(p, specificSample).values());
        }
        if (expectedFingerprints.isEmpty()) {
            throw new IllegalStateException("Could not find any fingerprints in: " + genotypeFiles);
        }
        ArrayList<FingerprintResults> resultsList = new ArrayList<FingerprintResults>();
        for (Path p : samFiles) {
            Map<FingerprintIdDetails, Fingerprint> fingerprintsByReadGroup = this.fingerprintSamFile(p, HaplotypeProbabilitiesFromSequence::new);
            if (ignoreReadGroups) {
                Fingerprint combinedFp = new Fingerprint(specificSample, p, null);
                fingerprintsByReadGroup.values().forEach(combinedFp::merge);
                FingerprintResults results = new FingerprintResults(p, null, specificSample);
                for (Fingerprint expectedFp : expectedFingerprints) {
                    MatchResults result = FingerprintChecker.calculateMatchResults(combinedFp, expectedFp, 0.0, this.pLossofHet);
                    results.addResults(result);
                }
                resultsList.add(results);
                continue;
            }
            for (FingerprintIdDetails rg : fingerprintsByReadGroup.keySet()) {
                FingerprintResults results = new FingerprintResults(p, rg.platformUnit, rg.sample);
                for (Fingerprint expectedFp : expectedFingerprints) {
                    MatchResults result = FingerprintChecker.calculateMatchResults(fingerprintsByReadGroup.get(rg), expectedFp, 0.0, this.pLossofHet);
                    results.addResults(result);
                }
                resultsList.add(results);
            }
        }
        return resultsList;
    }

    public List<FingerprintResults> checkFingerprintsFromPaths(List<Path> observedGenotypeFiles, List<Path> expectedGenotypeFiles, String observedSample, String expectedSample) {
        ArrayList<Fingerprint> expectedFingerprints = new ArrayList<Fingerprint>();
        for (Path p : expectedGenotypeFiles) {
            expectedFingerprints.addAll(this.loadFingerprints(p, expectedSample).values());
        }
        if (expectedFingerprints.isEmpty()) {
            throw new IllegalStateException("Could not find any fingerprints in: " + expectedGenotypeFiles);
        }
        ArrayList<FingerprintResults> resultsList = new ArrayList<FingerprintResults>();
        for (Path p : observedGenotypeFiles) {
            Map<String, Fingerprint> observedFingerprintsBySample = this.loadFingerprints(p, observedSample);
            if (observedFingerprintsBySample.isEmpty()) {
                throw new IllegalStateException("Found no fingerprints in observed genotypes file: " + observedGenotypeFiles);
            }
            for (String sample : observedFingerprintsBySample.keySet()) {
                FingerprintResults results = new FingerprintResults(p, null, sample);
                for (Fingerprint expectedFp : expectedFingerprints) {
                    MatchResults result = FingerprintChecker.calculateMatchResults(observedFingerprintsBySample.get(sample), expectedFp, 0.0, this.pLossofHet);
                    results.addResults(result);
                }
                resultsList.add(results);
            }
        }
        return resultsList;
    }

    public static MatchResults calculateMatchResults(Fingerprint observedFp, Fingerprint expectedFp, double minPExpected, double pLoH) {
        return FingerprintChecker.calculateMatchResults(observedFp, expectedFp, minPExpected, pLoH, true, true);
    }

    public static MatchResults calculateMatchResults(Fingerprint observedFp, Fingerprint expectedFp, double minPExpected, double pLoH, boolean calculateLocusInfo, boolean calculateTumorAwareLod) {
        ArrayList<LocusResult> locusResults = calculateLocusInfo ? new ArrayList<LocusResult>() : null;
        double llNoSwapModel = 0.0;
        double llSwapModel = 0.0;
        double lodExpectedSampleTumorNormal = 0.0;
        double lodExpectedSampleNormalTumor = 0.0;
        for (HaplotypeProbabilities probs2 : expectedFp.values()) {
            HaplotypeProbabilityOfNormalGivenTumor prob2AssumingDataFromTumor;
            HaplotypeProbabilityOfNormalGivenTumor prob1AssumingDataFromTumor;
            HaplotypeBlock haplotypeBlock = probs2.getHaplotype();
            HaplotypeProbabilities probs1 = (HaplotypeProbabilities)observedFp.get(haplotypeBlock);
            if (probs1 == null) continue;
            if (calculateTumorAwareLod) {
                prob1AssumingDataFromTumor = new HaplotypeProbabilityOfNormalGivenTumor(probs1, pLoH);
                prob2AssumingDataFromTumor = new HaplotypeProbabilityOfNormalGivenTumor(probs2, pLoH);
            } else {
                prob1AssumingDataFromTumor = null;
                prob2AssumingDataFromTumor = null;
            }
            Snp snp = probs2.getRepresentativeSnp();
            if (calculateLocusInfo) {
                DiploidGenotype externalGenotype = probs2.getMostLikelyGenotype(snp);
                LocusResult lr = new LocusResult(snp, externalGenotype, probs1.getMostLikelyGenotype(snp), probs1.getObsAllele1(), probs1.getObsAllele2(), probs1.getLodMostProbableGenotype(), probs1.shiftedLogEvidenceProbabilityGivenOtherEvidence(probs2), probs1.shiftedLogEvidenceProbability(), calculateTumorAwareLod ? prob1AssumingDataFromTumor.shiftedLogEvidenceProbabilityGivenOtherEvidence(probs2) - prob1AssumingDataFromTumor.shiftedLogEvidenceProbability() : 0.0, calculateTumorAwareLod ? probs1.shiftedLogEvidenceProbabilityGivenOtherEvidence(prob2AssumingDataFromTumor) - probs1.shiftedLogEvidenceProbability() : 0.0);
                locusResults.add(lr);
            }
            if (!probs1.hasEvidence() || !probs2.hasEvidence()) continue;
            llNoSwapModel += probs1.shiftedLogEvidenceProbabilityGivenOtherEvidence(probs2);
            llSwapModel += probs1.shiftedLogEvidenceProbability() + probs2.shiftedLogEvidenceProbability();
            if (!calculateTumorAwareLod) continue;
            lodExpectedSampleTumorNormal += prob1AssumingDataFromTumor.shiftedLogEvidenceProbabilityGivenOtherEvidence(probs2) - prob1AssumingDataFromTumor.shiftedLogEvidenceProbability() - probs2.shiftedLogEvidenceProbability();
            lodExpectedSampleNormalTumor += prob2AssumingDataFromTumor.shiftedLogEvidenceProbabilityGivenOtherEvidence(probs1) - prob2AssumingDataFromTumor.shiftedLogEvidenceProbability() - probs1.shiftedLogEvidenceProbability();
        }
        return new MatchResults(expectedFp.getSource(), expectedFp.getSample(), llNoSwapModel, llSwapModel, lodExpectedSampleTumorNormal, lodExpectedSampleNormalTumor, locusResults);
    }

    public static MatchResults calculateMatchResults(Fingerprint observedFp, Fingerprint expectedFp) {
        return FingerprintChecker.calculateMatchResults(observedFp, expectedFp, 0.0, 0.0);
    }

    public void setReferenceFasta(File referenceFasta) {
        this.referenceFasta = referenceFasta;
    }

    public int getLocusMaxReads() {
        return this.locusMaxReads;
    }

    public void setLocusMaxReads(int locusMaxReads) {
        this.locusMaxReads = locusMaxReads;
    }

    public String getDefaultSampleID() {
        return this.defaultSampleID;
    }

    public void setDefaultSampleID(String defaultSampleID) {
        this.defaultSampleID = defaultSampleID;
    }
}

