/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.barclay.help;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.broadinstitute.barclay.argparser.ArgumentDefinition;
import org.broadinstitute.barclay.argparser.CommandLineArgumentParser;
import org.broadinstitute.barclay.argparser.NamedArgumentDefinition;
import org.broadinstitute.barclay.argparser.PositionalArgumentDefinition;
import org.broadinstitute.barclay.argparser.RuntimeProperties;
import org.broadinstitute.barclay.argparser.SpecialArgumentsCollection;
import org.broadinstitute.barclay.argparser.WorkflowResource;
import org.broadinstitute.barclay.help.DefaultDocWorkUnitHandler;
import org.broadinstitute.barclay.help.DocWorkUnit;
import org.broadinstitute.barclay.help.HelpDoclet;
import org.broadinstitute.barclay.help.WDLTransforms;

public class WDLWorkUnitHandler
extends DefaultDocWorkUnitHandler {
    private static final String GATK_FREEMARKER_TEMPLATE_NAME = "wdlToolTemplate.wdl.ftl";
    private static final String LONG_OPTION_PREFIX = "--";
    private Map<String, String> runtimeOutputs = new HashMap<String, String>();
    private Map<String, List<String>> companionFiles = new HashMap<String, List<String>>();
    public static final String RUNTIME_PROPERTIES = "runtimeProperties";
    public static final String RUNTIME_PROPERTY_MEMORY = "memoryRequirements";
    public static final String RUNTIME_PROPERTY_DISKS = "diskRequirements";
    public static final String RUNTIME_PROPERTY_CPU = "cpuRequirements";
    public static final String RUNTIME_PROPERTY_BOOT_DISK_SIZE_GB = "bootdisksizegbRequirements";
    public static final String RUNTIME_PROPERTY_PREEMPTIBLE = "preemptibleRequirements";
    public static final String RUNTIME_OUTPUTS = "runtimeOutputs";
    public static final String COMPANION_RESOURCES = "companionResources";
    public static final String POSITIONAL_ARGS = "positionalArgs";

    public WDLWorkUnitHandler(HelpDoclet doclet) {
        super(doclet);
    }

    @Override
    public String getTemplateName(DocWorkUnit workUnit) {
        return GATK_FREEMARKER_TEMPLATE_NAME;
    }

    @Override
    protected void addCommandLineArgumentBindings(DocWorkUnit currentWorkUnit, CommandLineArgumentParser clp) {
        super.addCommandLineArgumentBindings(currentWorkUnit, clp);
        HashMap<String, String> runtimeOutputsForFreemarker = new HashMap<String, String>();
        runtimeOutputsForFreemarker.putAll(this.runtimeOutputs);
        currentWorkUnit.getRootMap().put(RUNTIME_OUTPUTS, runtimeOutputsForFreemarker);
        this.runtimeOutputs.clear();
        Map argMap = (Map)currentWorkUnit.getRootMap().get("arguments");
        List allArgsMap = (List)argMap.get("all");
        HashMap argCompanionResourceArgMaps = new HashMap();
        allArgsMap.forEach(m -> {
            String argName = (String)m.get("name");
            Map argPropertiesMap = m;
            ArrayList argCompanions = new ArrayList();
            if (this.companionFiles.containsKey(argName)) {
                for (String companion : this.companionFiles.get(argName)) {
                    HashMap<String, String> companionMap = new HashMap<String, String>();
                    companionMap.putAll(argPropertiesMap);
                    companionMap.put("name", companion);
                    companionMap.put("synonyms", "");
                    companionMap.put("summary", "Companion resource for: " + companionMap.get("summary"));
                    argCompanions.add(companionMap);
                }
                argCompanionResourceArgMaps.put(argName, argCompanions);
            }
        });
        currentWorkUnit.getRootMap().put(COMPANION_RESOURCES, argCompanionResourceArgMaps);
    }

    @Override
    protected void processNamedArgument(DocWorkUnit currentWorkUnit, Map<String, List<Map<String, Object>>> args, NamedArgumentDefinition argDef) {
        if (!argDef.getUnderlyingField().getDeclaringClass().equals(SpecialArgumentsCollection.class)) {
            super.processNamedArgument(currentWorkUnit, args, argDef);
        }
    }

    @Override
    protected String processNamedArgument(Map<String, Object> argBindings, NamedArgumentDefinition argDef, String fieldCommentText) {
        String argCategory = super.processNamedArgument(argBindings, argDef, fieldCommentText);
        WorkflowResource workflowResource = this.getWorkflowResource(argDef);
        String wdlType = this.getWDLTypeForArgument(argDef, null, (String)argBindings.get("type"));
        String wdlInputType = this.getWDLTypeForArgument(argDef, workflowResource, (String)argBindings.get("type"));
        argBindings.put("type", wdlType);
        argBindings.put("wdlinputtype", wdlInputType);
        String actualArgName = (String)argBindings.get("name");
        argBindings.put("actualArgName", actualArgName);
        String wdlName = LONG_OPTION_PREFIX + this.transformJavaNameToWDLName(actualArgName.substring(2));
        argBindings.put("name", wdlName);
        if (workflowResource != null) {
            this.updateWorkflowOutputs(workflowResource, wdlName, wdlType);
        }
        return argCategory;
    }

    @Override
    protected void processPositionalArguments(CommandLineArgumentParser clp, Map<String, List<Map<String, Object>>> argBindings) {
        super.processPositionalArguments(clp, argBindings);
        PositionalArgumentDefinition argDef = clp.getPositionalArgumentDefinition();
        if (argDef != null) {
            WorkflowResource workflowResource = this.getWorkflowResource(argDef);
            String wdlType = this.getWDLTypeForArgument(argDef, null, (String)argBindings.get("positional").get(0).get("type"));
            String wdlInputType = this.getWDLTypeForArgument(argDef, workflowResource, (String)argBindings.get("positional").get(0).get("type"));
            argBindings.get("positional").get(0).put("type", wdlType);
            argBindings.get("positional").get(0).put("wdlinputtype", wdlInputType);
            if (workflowResource != null) {
                this.updateWorkflowOutputs(workflowResource, POSITIONAL_ARGS, wdlType);
            }
        }
    }

    protected final WorkflowResource getWorkflowResource(ArgumentDefinition argDef) {
        WorkflowResource workFlowResource = argDef.getUnderlyingField().getAnnotation(WorkflowResource.class);
        if (workFlowResource != null && !workFlowResource.input() && !workFlowResource.output()) {
            throw new IllegalArgumentException(String.format("WorkFlowResource for %s in %s must be marked as either an INPUT or an OUTPUT", argDef.getUnderlyingField(), argDef.getContainingObject().getClass()));
        }
        return workFlowResource;
    }

    protected void updateWorkflowOutputs(WorkflowResource workflowResource, String wdlName, String wdlType) {
        if (workflowResource.output()) {
            this.runtimeOutputs.put(wdlName, wdlType);
        }
        for (String companion : workflowResource.companionResources()) {
            String companionArgOption = LONG_OPTION_PREFIX + companion;
            this.companionFiles.merge(wdlName, Collections.singletonList(companionArgOption), (oldList, newList) -> {
                ArrayList<String> mergedList = new ArrayList<String>();
                mergedList.addAll((Collection<String>)oldList);
                mergedList.add(companionArgOption);
                return mergedList;
            });
        }
    }

    protected String getWDLTypeForArgument(ArgumentDefinition argDef, WorkflowResource workflowResource, String argDocType) {
        Field argField = argDef.getUnderlyingField();
        Class<?> argumentClass = argField.getType();
        String wdlType = argDocType;
        if (argDef.isCollection()) {
            Pair<String, String> conversionPair = this.transformToWDLCollectionType(argumentClass);
            if (conversionPair == null) {
                throw new IllegalArgumentException(String.format("Unrecognized collection type %s for argument %s in work unit %s.Argument collection type must be one of List or Set.", argumentClass, argField.getName(), argField.getDeclaringClass()));
            }
            wdlType = wdlType.replace(conversionPair.getLeft(), conversionPair.getRight());
            Type typeParamType = argField.getGenericType();
            if (typeParamType instanceof ParameterizedType) {
                ParameterizedType pType = (ParameterizedType)typeParamType;
                Type[] genericTypes = pType.getActualTypeArguments();
                if (genericTypes.length != 1) {
                    throw new RuntimeException(String.format("Generating WDL for tools with arguments that have types that require multiple type parameters is not supported (class %s for arg %s in %s has multiple type parameters).", argumentClass, argField.getName(), argField.getDeclaringClass()));
                }
                ParameterizedType pType2 = null;
                try {
                    if (genericTypes[0] instanceof ParameterizedType) {
                        pType2 = (ParameterizedType)genericTypes[0];
                        Type[] genericTypes2 = pType2.getActualTypeArguments();
                        if (genericTypes2.length != 1) {
                            throw new RuntimeException(String.format("Generating WDL for tools with args with multiple type parameters is not supported (class %s for arg %s in %s has multiple type parameters).", argumentClass, argField.getName(), argField.getDeclaringClass()));
                        }
                        Class<?> nestedTypeClass = Class.forName(pType2.getRawType().getTypeName());
                        wdlType = this.convertJavaTypeToWDLType(workflowResource, nestedTypeClass, wdlType, argField.getDeclaringClass().toString());
                    } else {
                        Class<?> nestedTypeClass = Class.forName(genericTypes[0].getTypeName());
                        wdlType = this.convertJavaTypeToWDLType(workflowResource, nestedTypeClass, wdlType, argField.getDeclaringClass().toString());
                    }
                    return wdlType;
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(String.format("WDL generation can't find class %s for %s", pType2.getRawType().toString(), argField.getDeclaringClass()), e);
                }
            }
            throw new RuntimeException(String.format("Generic type must have a ParameterizedType (class %s for argument %s/%s)", argumentClass, argField.getName(), argField.getDeclaringClass()));
        }
        return this.convertJavaTypeToWDLType(workflowResource, argumentClass, wdlType, argField.getDeclaringClass().toString());
    }

    protected String convertJavaTypeToWDLType(WorkflowResource workflowResource, Class<?> argumentClass, String docType, String sourceContext) {
        String convertedWDLType;
        Pair<String, String> typeConversionPair = this.transformToWDLType(argumentClass);
        if (typeConversionPair != null) {
            convertedWDLType = docType.replace(typeConversionPair.getKey(), typeConversionPair.getValue());
        } else if (argumentClass.isEnum()) {
            convertedWDLType = docType.replace(argumentClass.getSimpleName(), "String");
        } else {
            throw new RuntimeException(String.format("Don't know how to convert Java type %s in %s to a corresponding WDL type. The WDL generator type converter code must be updated to support this Java type.", argumentClass, sourceContext));
        }
        return this.transformWorkflowResourceOutputTypeToInputType(workflowResource, convertedWDLType);
    }

    protected String transformWorkflowResourceOutputTypeToInputType(WorkflowResource workflowResource, String convertedWDLType) {
        return workflowResource != null && workflowResource.output() && convertedWDLType.equals("File") ? "String" : convertedWDLType;
    }

    protected Pair<String, String> transformToWDLType(Class<?> argumentClass) {
        return WDLTransforms.transformToWDLType(argumentClass);
    }

    protected String transformJavaNameToWDLName(String candidateName) {
        return WDLTransforms.transformJavaNameToWDLName(candidateName);
    }

    protected Pair<String, String> transformToWDLCollectionType(Class<?> argumentCollectionClass) {
        return WDLTransforms.transformToWDLCollectionType(argumentCollectionClass);
    }

    @Override
    protected void addCustomBindings(DocWorkUnit currentWorkUnit) {
        super.addCustomBindings(currentWorkUnit);
        RuntimeProperties rtProperties = currentWorkUnit.getClazz().getAnnotation(RuntimeProperties.class);
        if (rtProperties != null) {
            HashMap<String, String> runtimePropertiesMap = new HashMap<String, String>();
            runtimePropertiesMap.put(RUNTIME_PROPERTY_MEMORY, rtProperties.memory());
            runtimePropertiesMap.put(RUNTIME_PROPERTY_DISKS, rtProperties.disks());
            runtimePropertiesMap.put(RUNTIME_PROPERTY_CPU, Integer.toString(rtProperties.cpu()));
            runtimePropertiesMap.put(RUNTIME_PROPERTY_PREEMPTIBLE, Integer.toString(rtProperties.preEmptible()));
            runtimePropertiesMap.put(RUNTIME_PROPERTY_BOOT_DISK_SIZE_GB, Integer.toString(rtProperties.bootDiskSizeGb()));
            currentWorkUnit.setProperty(RUNTIME_PROPERTIES, runtimePropertiesMap);
        }
    }

    @Override
    protected void addExtraDocsBindings(DocWorkUnit currentWorkUnit) {
    }
}

