/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.BinaryCigarCodec;
import htsjdk.samtools.BinaryTagCodec;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMBinaryTagAndValue;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.util.StringUtil;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class BAMRecord
extends SAMRecord {
    private static final int READ_NAME_OFFSET = 0;
    public static final short CIGAR_SIZE_MULTIPLIER = 4;
    public static final int MAX_CIGAR_OPERATORS = 65535;
    public static final int MAX_CIGAR_ELEMENT_LENGTH = 0xFFFFFFF;
    private static final int LONG_CIGAR_SENTINEL_LENGTH = 2;
    private byte[] mRestOfBinaryData = null;
    private int mReadLength = 0;
    private boolean mReadLengthValid = true;
    private final short mReadNameLength;
    private boolean mReadNameLengthValid = true;
    private final int mCigarLength;
    private boolean mCigarLengthValid = true;
    private boolean mAttributesDecoded = false;
    private boolean mCigarDecoded = false;
    private boolean mBinaryDataStale;

    protected BAMRecord(SAMFileHeader header, int referenceID, int coordinate, short readNameLength, short mappingQuality, int indexingBin, int cigarLen, int flags, int readLen, int mateReferenceID, int mateCoordinate, int insertSize, byte[] restOfData) {
        super(header);
        this.setReferenceIndex(referenceID);
        this.setAlignmentStart(coordinate);
        this.mReadNameLength = readNameLength;
        this.setMappingQuality(mappingQuality);
        this.mCigarLength = cigarLen;
        this.setFlags(flags);
        this.mReadLength = readLen;
        this.setMateReferenceIndex(mateReferenceID);
        this.setMateAlignmentStart(mateCoordinate);
        this.setInferredInsertSize(insertSize);
        this.mRestOfBinaryData = restOfData;
        super.setReadName(null);
        super.setCigarString(null);
        super.setReadBases(null);
        super.setBaseQualities(null);
        this.mBinaryDataStale = false;
    }

    @Override
    protected void eagerDecode() {
        this.getReadName();
        this.getCigar();
        this.getReadBases();
        this.getBaseQualities();
        this.getBinaryAttributes();
        super.eagerDecode();
        this.mRestOfBinaryData = null;
    }

    @Override
    public byte[] getVariableBinaryRepresentation() {
        if (this.mBinaryDataStale) {
            return null;
        }
        return this.mRestOfBinaryData;
    }

    @Override
    public int getAttributesBinarySize() {
        if (this.mBinaryDataStale || this.mRestOfBinaryData == null) {
            return -1;
        }
        int tagsOffset = this.readNameSize() + this.cigarSize() + this.basesSize() + this.qualsSize();
        return this.mRestOfBinaryData.length - tagsOffset;
    }

    @Override
    public void setReadName(String value) {
        super.setReadName(value);
        this.mBinaryDataStale = true;
        this.mReadNameLengthValid = false;
    }

    @Override
    public void setCigar(Cigar cigar) {
        super.setCigar(cigar);
        this.mBinaryDataStale = true;
        this.mCigarLengthValid = false;
        this.mCigarDecoded = true;
    }

    @Override
    public void setCigarString(String value) {
        super.setCigarString(value);
        this.mBinaryDataStale = true;
        this.mCigarLengthValid = false;
        this.mCigarDecoded = true;
    }

    @Override
    public void setReadBases(byte[] value) {
        super.setReadBases(value);
        this.mBinaryDataStale = true;
        this.mReadLengthValid = false;
    }

    @Override
    public void setBaseQualities(byte[] value) {
        super.setBaseQualities(value);
        this.mBinaryDataStale = true;
    }

    @Override
    protected void setAttribute(short tag, Object value, boolean isUnsignedArray) {
        this.getBinaryAttributes();
        super.setAttribute(tag, value, isUnsignedArray);
        this.mBinaryDataStale = true;
    }

    @Override
    public void clearAttributes() {
        if (!this.mAttributesDecoded) {
            this.getCigar();
        }
        this.mAttributesDecoded = true;
        this.mBinaryDataStale = true;
        super.clearAttributes();
    }

    @Override
    public int getReadLength() {
        if (this.mReadLengthValid) {
            return this.mReadLength;
        }
        return super.getReadLength();
    }

    @Override
    public String getReadName() {
        String result = super.getReadName();
        if (this.mRestOfBinaryData != null && result == null) {
            result = this.decodeReadName();
            super.setReadName(result);
        }
        return result;
    }

    @Override
    public int getReadNameLength() {
        if (this.mReadNameLengthValid) {
            return this.mReadNameLength - 1;
        }
        return super.getReadNameLength();
    }

    @Override
    public Cigar getCigar() {
        if (this.mRestOfBinaryData != null && !this.mCigarDecoded) {
            int cigarOffset = this.readNameSize();
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.mRestOfBinaryData, cigarOffset, this.cigarSize());
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            super.initializeCigar(BinaryCigarCodec.decode(byteBuffer));
            this.mCigarDecoded = true;
            if (this.getCigarLength() == 2 && BAMRecord.isSentinelCigar(super.getCigar(), this.getReadLength())) {
                this.extractCigarFromCGAttribute(super.getCigar());
            }
            if (null != this.getHeader() && this.getValidationStringency() != ValidationStringency.SILENT && !this.getReadUnmappedFlag()) {
                SAMUtils.processValidationErrors(this.validateCigar(-1L), -1L, this.getValidationStringency());
            }
        }
        return super.getCigar();
    }

    static boolean isSentinelCigar(Cigar cigar, int readLength) {
        return cigar.numCigarElements() == 2 && cigar.getCigarElement(1).getOperator() == CigarOperator.N && cigar.getCigarElement(0).getOperator() == CigarOperator.S && (cigar.getCigarElement(0).getLength() == readLength || readLength == 0);
    }

    private void extractCigarFromCGAttribute(Cigar sentinelCigar) throws IllegalStateException {
        int[] cigarFromCG = (int[])this.getAttribute(SAMTag.CG.getBinaryTag());
        if (cigarFromCG == null) {
            return;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(cigarFromCG.length * 4).order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.asIntBuffer().put(cigarFromCG);
        Cigar decodedCigar = BinaryCigarCodec.decode(byteBuffer);
        if (decodedCigar.numCigarElements() <= 65535) {
            throw new IllegalStateException(String.format("Only Cigar with > %d operators should be placed in CG tag. Found %d operators. \n Here's the Cigar:\n%s", 65535, decodedCigar.getCigarElements().size(), decodedCigar.toString()));
        }
        if (decodedCigar.getReferenceLength() != sentinelCigar.getReferenceLength()) {
            throw new IllegalStateException(String.format("Sentinel cigar and %s cigar should have the same reference length. Found %d and %d.\n Here's the Cigar:\n%s", SAMTag.CG.name(), sentinelCigar.getReferenceLength(), decodedCigar.getReferenceLength(), decodedCigar.toString()));
        }
        if (decodedCigar.getReadLength() != sentinelCigar.getReadLength()) {
            throw new IllegalStateException(String.format("Sentinel cigar and %s cigar should have the same read length. Found %d and %d.\n Here's the Cigar:\n%s", SAMTag.CG.name(), sentinelCigar.getReadLength(), decodedCigar.getReadLength(), decodedCigar.toString()));
        }
        this.initializeCigar(decodedCigar);
        this.setAttribute(SAMTag.CG.getBinaryTag(), null);
    }

    @Override
    public int getCigarLength() {
        if (this.mCigarLengthValid) {
            return this.mCigarLength;
        }
        return super.getCigarLength();
    }

    @Override
    public byte[] getReadBases() {
        byte[] result = super.getReadBases();
        if (this.mRestOfBinaryData != null && result == null) {
            result = this.decodeReadBases();
            super.setReadBases(result);
        }
        return result;
    }

    @Override
    public byte[] getBaseQualities() {
        byte[] ret = super.getBaseQualities();
        if (this.mRestOfBinaryData != null && ret == null) {
            ret = this.decodeBaseQualities();
            super.setBaseQualities(ret);
        }
        return ret;
    }

    @Override
    public Object getAttribute(short tag) {
        if (!this.mAttributesDecoded) {
            this.decodeAttributes();
        }
        return super.getAttribute(tag);
    }

    @Override
    protected SAMBinaryTagAndValue getBinaryAttributes() {
        if (!this.mAttributesDecoded) {
            this.decodeAttributes();
        }
        return super.getBinaryAttributes();
    }

    private void decodeAttributes() {
        if (this.mAttributesDecoded) {
            return;
        }
        this.mAttributesDecoded = true;
        int tagsOffset = this.readNameSize() + this.cigarSize() + this.basesSize() + this.qualsSize();
        int tagsSize = this.mRestOfBinaryData.length - tagsOffset;
        SAMBinaryTagAndValue attributes = BinaryTagCodec.readTags(this.mRestOfBinaryData, tagsOffset, tagsSize, this.getValidationStringency());
        this.setAttributes(attributes);
        if (this.hasAttribute(SAMTag.CG.name())) {
            this.getCigar();
        }
    }

    private byte[] decodeBaseQualities() {
        if (this.mReadLength == 0) {
            return SAMRecord.NULL_QUALS;
        }
        int qualsOffset = this.readNameSize() + this.cigarSize() + this.basesSize();
        byte[] ret = new byte[this.qualsSize()];
        System.arraycopy(this.mRestOfBinaryData, qualsOffset, ret, 0, this.qualsSize());
        if (ret.length > 0 && ret[0] == -1) {
            return NULL_QUALS;
        }
        return ret;
    }

    private String decodeReadName() {
        return StringUtil.bytesToString(this.mRestOfBinaryData, 0, this.mReadNameLength - 1);
    }

    private byte[] decodeReadBases() {
        if (this.mReadLength == 0) {
            return NULL_SEQUENCE;
        }
        int basesOffset = this.readNameSize() + this.cigarSize();
        try {
            return SAMUtils.compressedBasesToBytes(this.mReadLength, this.mRestOfBinaryData, basesOffset);
        }
        catch (IllegalArgumentException ex) {
            String msg = ex.getMessage() + " in read: " + this.getReadName();
            throw new IllegalStateException(msg, ex);
        }
    }

    private int readNameSize() {
        return this.mReadNameLength;
    }

    private int cigarSize() {
        return this.mCigarLength * 4;
    }

    private int basesSize() {
        return (this.mReadLength + 1) / 2;
    }

    private int qualsSize() {
        return this.mReadLength;
    }
}

