/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.samtools.util.SortingCollection;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.writer.Options;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.variantcontext.writer.VariantContextWriterBuilder;
import htsjdk.variant.vcf.VCFFileReader;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFRecordCodec;
import htsjdk.variant.vcf.VCFUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.VariantManipulationProgramGroup;

@CommandLineProgramProperties(summary="Sorts one or more VCF files.  This tool sorts the records in VCF files according to the order of the contigs in the header/sequence dictionary and then by coordinate. It can accept an external sequence dictionary. If no external dictionary is supplied, the VCF file headers of multiple inputs must have the same sequence dictionaries.<br /><br />If running on multiple inputs (originating from e.g. some scatter-gather runs), the input files must contain the same sample names in the same column order. <br /><h4>Usage example:</h4><pre>java -jar picard.jar SortVcf \\<br />      I=vcf_1.vcf \\<br />      I=vcf_2.vcf \\<br />      O=sorted.vcf</pre><hr />", oneLineSummary="Sorts one or more VCF files.  ", programGroup=VariantManipulationProgramGroup.class)
@DocumentedFeature
public class SortVcf
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Sorts one or more VCF files.  ";
    static final String USAGE_DETAILS = "This tool sorts the records in VCF files according to the order of the contigs in the header/sequence dictionary and then by coordinate. It can accept an external sequence dictionary. If no external dictionary is supplied, the VCF file headers of multiple inputs must have the same sequence dictionaries.<br /><br />If running on multiple inputs (originating from e.g. some scatter-gather runs), the input files must contain the same sample names in the same column order. <br /><h4>Usage example:</h4><pre>java -jar picard.jar SortVcf \\<br />      I=vcf_1.vcf \\<br />      I=vcf_2.vcf \\<br />      O=sorted.vcf</pre><hr />";
    @Argument(shortName="I", doc="Input VCF(s) to be sorted. Multiple inputs must have the same sample names (in order)")
    public List<File> INPUT;
    @Argument(shortName="O", doc="Output VCF to be written.")
    public File OUTPUT;
    @Argument(shortName="SD", optional=true)
    public File SEQUENCE_DICTIONARY;
    private final Log log = Log.getInstance(SortVcf.class);
    private final List<VCFFileReader> inputReaders = new ArrayList<VCFFileReader>();
    private final List<VCFHeader> inputHeaders = new ArrayList<VCFHeader>();

    public SortVcf() {
        this.CREATE_INDEX = true;
    }

    @Override
    protected int doWork() {
        ArrayList<String> sampleList = new ArrayList<String>();
        for (File input : this.INPUT) {
            IOUtil.assertFileIsReadable(input);
        }
        if (this.SEQUENCE_DICTIONARY != null) {
            IOUtil.assertFileIsReadable(this.SEQUENCE_DICTIONARY);
        }
        SAMSequenceDictionary samSequenceDictionary = null;
        if (this.SEQUENCE_DICTIONARY != null) {
            samSequenceDictionary = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).getFileHeader(this.SEQUENCE_DICTIONARY).getSequenceDictionary();
            CloserUtil.close(this.SEQUENCE_DICTIONARY);
        }
        this.collectFileReadersAndHeaders(sampleList, samSequenceDictionary);
        VCFHeader outputHeader = new VCFHeader(VCFUtils.smartMergeHeaders(this.inputHeaders, false), sampleList);
        SortingCollection<VariantContext> sortedOutput = this.sortInputs(this.inputReaders, outputHeader);
        this.writeSortedOutput(outputHeader, sortedOutput);
        return 0;
    }

    private void collectFileReadersAndHeaders(List<String> sampleList, SAMSequenceDictionary samSequenceDictionary) {
        for (File input : this.INPUT) {
            VCFFileReader in = new VCFFileReader(input, false);
            VCFHeader header = in.getFileHeader();
            SAMSequenceDictionary dict = in.getFileHeader().getSequenceDictionary();
            if (dict == null || dict.isEmpty()) {
                if (null == samSequenceDictionary) {
                    throw new IllegalArgumentException("Sequence dictionary was missing or empty for the VCF: " + input.getAbsolutePath() + " Please add a sequence dictionary to this VCF or specify SEQUENCE_DICTIONARY.");
                }
                header.setSequenceDictionary(samSequenceDictionary);
            } else if (null == samSequenceDictionary) {
                samSequenceDictionary = dict;
            } else {
                try {
                    samSequenceDictionary.assertSameDictionary(dict);
                }
                catch (AssertionError e) {
                    throw new IllegalArgumentException((Throwable)((Object)e));
                }
            }
            if (sampleList.isEmpty()) {
                sampleList.addAll(header.getSampleNamesInOrder());
            } else if (!sampleList.equals(header.getSampleNamesInOrder())) {
                throw new IllegalArgumentException("Input file " + input.getAbsolutePath() + " has sample names that don't match the other files.");
            }
            this.inputReaders.add(in);
            this.inputHeaders.add(header);
        }
    }

    private SortingCollection<VariantContext> sortInputs(List<VCFFileReader> readers, VCFHeader outputHeader) {
        ProgressLogger readProgress = new ProgressLogger(this.log, 25000, "read", "records");
        SortingCollection<VariantContext> sorter = SortingCollection.newInstance(VariantContext.class, new VCFRecordCodec(outputHeader, this.VALIDATION_STRINGENCY != ValidationStringency.STRICT), outputHeader.getVCFRecordComparator(), (int)this.MAX_RECORDS_IN_RAM, this.TMP_DIR);
        int readerCount = 1;
        for (VCFFileReader reader : readers) {
            this.log.info("Reading entries from input file " + readerCount);
            for (VariantContext variantContext : reader) {
                sorter.add(variantContext);
                readProgress.record(variantContext.getContig(), variantContext.getStart());
            }
            reader.close();
            ++readerCount;
        }
        return sorter;
    }

    private void writeSortedOutput(VCFHeader outputHeader, SortingCollection<VariantContext> sortedOutput) {
        ProgressLogger writeProgress = new ProgressLogger(this.log, 25000, "wrote", "records");
        EnumSet<Options> options = this.CREATE_INDEX != false ? EnumSet.of(Options.INDEX_ON_THE_FLY) : EnumSet.noneOf(Options.class);
        VariantContextWriter out = new VariantContextWriterBuilder().setReferenceDictionary(outputHeader.getSequenceDictionary()).setOptions(options).setOutputFile(this.OUTPUT).build();
        out.writeHeader(outputHeader);
        for (VariantContext variantContext : sortedOutput) {
            out.add(variantContext);
            writeProgress.record(variantContext.getContig(), variantContext.getStart());
        }
        out.close();
    }
}

