/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf;

import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.util.IOUtil;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.DiagnosticsAndQCProgramGroup;
import picard.vcf.CollectVariantCallingMetrics;

@CommandLineProgramProperties(summary="Combines multiple Variant Calling Metrics files into a single file.  This tool is used in cases where the metrics are calculated separately for different (genomic) shards of the same callset and we want to combine them into a single result over the entire callset. The shards are expected to contain the same samples (although it will not fail if they do not) and to not have been run over overlapping genomic positions.", oneLineSummary="Combines multiple Variant Calling Metrics files into a single file", programGroup=DiagnosticsAndQCProgramGroup.class)
@DocumentedFeature
public class AccumulateVariantCallingMetrics
extends CommandLineProgram {
    @Argument(shortName="I", doc="Paths (except for the file extensions) of Variant Calling Metrics files to read and merge.", minElements=1)
    public List<File> INPUT;
    @Argument(shortName="O", doc="Path (except for the file extension) of output metrics files to write.")
    public File OUTPUT;

    @Override
    protected int doWork() {
        String outputPrefix = this.OUTPUT.getAbsolutePath() + ".";
        File detailOutputFile = new File(outputPrefix + CollectVariantCallingMetrics.VariantCallingDetailMetrics.getFileExtension());
        File summaryOutputFile = new File(outputPrefix + CollectVariantCallingMetrics.VariantCallingSummaryMetrics.getFileExtension());
        IOUtil.assertFileIsWritable(detailOutputFile);
        IOUtil.assertFileIsWritable(summaryOutputFile);
        HashMap<String, CollectVariantCallingMetrics.VariantCallingDetailMetrics> collapsedSampleDetailsMap = new HashMap<String, CollectVariantCallingMetrics.VariantCallingDetailMetrics>();
        CollectVariantCallingMetrics.VariantCallingSummaryMetrics collapsedSummary = new CollectVariantCallingMetrics.VariantCallingSummaryMetrics();
        for (File file : this.INPUT) {
            String inputPrefix = file.getAbsolutePath() + ".";
            try {
                File detail = new File(inputPrefix + CollectVariantCallingMetrics.VariantCallingDetailMetrics.getFileExtension());
                IOUtil.assertFileIsReadable(detail);
                MetricsFile detailedMetricsFile = this.getMetricsFile();
                detailedMetricsFile.read(new FileReader(detail));
                long totalHetDepth = 0L;
                for (CollectVariantCallingMetrics.VariantCallingDetailMetrics detailedMetrics : detailedMetricsFile.getMetrics()) {
                    detailedMetrics.calculateFromDerivedFields();
                    totalHetDepth += detailedMetrics.TOTAL_HET_DEPTH;
                    CollectVariantCallingMetrics.VariantCallingDetailMetrics sampleDetails = collapsedSampleDetailsMap.computeIfAbsent(detailedMetrics.SAMPLE_ALIAS, f -> new CollectVariantCallingMetrics.VariantCallingDetailMetrics());
                    sampleDetails.merge(detailedMetrics);
                }
                File summary = new File(inputPrefix + CollectVariantCallingMetrics.VariantCallingSummaryMetrics.getFileExtension());
                IOUtil.assertFileIsReadable(summary);
                MetricsFile summaryMetricsFile = this.getMetricsFile();
                summaryMetricsFile.read(new FileReader(summary));
                if (summaryMetricsFile.getMetrics().size() != 1) {
                    throw new PicardException(String.format("Expected 1 row in the summary metrics file but saw %d", summaryMetricsFile.getMetrics().size()));
                }
                CollectVariantCallingMetrics.VariantCallingSummaryMetrics summaryMetrics = (CollectVariantCallingMetrics.VariantCallingSummaryMetrics)summaryMetricsFile.getMetrics().get(0);
                summaryMetrics.calculateFromDerivedFields(totalHetDepth);
                collapsedSummary.merge(summaryMetrics);
            }
            catch (IOException e) {
                throw new PicardException(String.format("Cannot read from metrics files with prefix %s", inputPrefix));
            }
        }
        MetricsFile detail = this.getMetricsFile();
        collapsedSampleDetailsMap.values().forEach(v -> {
            v.calculateDerivedFields();
            detail.addMetric(v);
        });
        detail.write(detailOutputFile);
        MetricsFile summary = this.getMetricsFile();
        collapsedSummary.calculateDerivedFields();
        summary.addMetric(collapsedSummary);
        summary.write(summaryOutputFile);
        return 0;
    }
}

