/*
 * Decompiled with CFR 0.152.
 */
package picard.util;

import htsjdk.samtools.util.StringUtil;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypeBuilder;
import htsjdk.variant.variantcontext.GenotypeLikelihoods;
import htsjdk.variant.variantcontext.GenotypesContext;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import picard.fingerprint.Snp;
import picard.util.MathUtil;

public final class AlleleSubsettingUtils {
    static final Allele NON_REF_ALLELE = Allele.create("<NON_REF>");
    static List<Allele> DIPLOID_NO_CALL = Arrays.asList(Allele.NO_CALL, Allele.NO_CALL);

    public static VariantContext subsetVCToMatchSnp(VariantContext ctx, Snp snp) {
        if (ctx.isFiltered()) {
            return null;
        }
        if (ctx.getReference().length() != 1) {
            return null;
        }
        Optional<Byte> referenceAlleleMaybe = Stream.of(snp.getAllele1(), snp.getAllele2()).filter(b -> StringUtil.toUpperCase(b) == StringUtil.toUpperCase(ctx.getReference().getBases()[0])).findAny();
        if (!referenceAlleleMaybe.isPresent()) {
            return null;
        }
        byte refAllele = referenceAlleleMaybe.get();
        byte otherAllele = snp.getAllele1() == refAllele ? snp.getAllele2() : snp.getAllele1();
        Optional<Allele> altAlleleMaybe = ctx.getAlternateAlleles().stream().filter(a -> a.length() == 1 && StringUtil.toUpperCase(a.getBases()[0]) == StringUtil.toUpperCase(otherAllele)).findAny();
        if (altAlleleMaybe.isPresent()) {
            if (ctx.isBiallelic()) {
                return ctx;
            }
            return AlleleSubsettingUtils.subsetAlleles(ctx, Arrays.asList(ctx.getReference(), altAlleleMaybe.get()));
        }
        Optional<Allele> nonRefAlleleMaybe = ctx.getAlternateAlleles().stream().filter(a -> a.equals(NON_REF_ALLELE)).findAny();
        if (nonRefAlleleMaybe.isPresent()) {
            VariantContext vcSubsetted = ctx.isBiallelic() ? ctx : AlleleSubsettingUtils.subsetAlleles(ctx, Arrays.asList(ctx.getReference(), nonRefAlleleMaybe.get()));
            return AlleleSubsettingUtils.swapAlleles(vcSubsetted, NON_REF_ALLELE, Allele.create(otherAllele));
        }
        return null;
    }

    public static VariantContext subsetAlleles(VariantContext originalVc, List<Allele> allelesToKeep) {
        VariantContextBuilder vcBuilder = new VariantContextBuilder(originalVc).alleles((Collection<Allele>)allelesToKeep);
        GenotypesContext newGenotypes = AlleleSubsettingUtils.subsetAlleles(originalVc.getGenotypes(), originalVc.getAlleles(), allelesToKeep);
        vcBuilder.genotypes(newGenotypes);
        return vcBuilder.make();
    }

    public static VariantContext swapAlleles(VariantContext originalVc, Allele oldAllele, Allele newAllele) throws IllegalArgumentException {
        if (!originalVc.getAlleles().contains(oldAllele)) {
            throw new IllegalArgumentException("Couldn't find allele " + oldAllele + " in VariantContext " + originalVc);
        }
        ArrayList<Allele> alleles = new ArrayList<Allele>(originalVc.getAlleles());
        alleles.set(alleles.indexOf(oldAllele), newAllele);
        VariantContextBuilder vcBuilder = new VariantContextBuilder(originalVc).alleles((Collection<Allele>)alleles);
        GenotypesContext newGTs = GenotypesContext.create(originalVc.getGenotypes().size());
        for (Genotype g : originalVc.getGenotypes()) {
            if (!g.getAlleles().contains(oldAllele)) {
                newGTs.add(g);
                continue;
            }
            GenotypeBuilder gb = new GenotypeBuilder(g);
            gb.alleles(g.getAlleles().stream().map(a -> a.equals(oldAllele) ? newAllele : a).collect(Collectors.toList()));
            newGTs.add(gb.make());
        }
        vcBuilder.genotypes(newGTs);
        return vcBuilder.make();
    }

    public static GenotypesContext subsetAlleles(GenotypesContext originalGs, List<Allele> originalAlleles, List<Allele> allelesToKeep) {
        AlleleSubsettingUtils.nonNull(originalGs, "original GenotypesContext must not be null.");
        AlleleSubsettingUtils.nonNull(allelesToKeep, "allelesToKeep is null.");
        AlleleSubsettingUtils.nonEmpty(allelesToKeep, "must keep at least one allele.");
        AlleleSubsettingUtils.validateTrue(allelesToKeep.get(0).isReference(), "First allele must be the reference allele.");
        AlleleSubsettingUtils.validateTrue(allelesToKeep.stream().allMatch(originalAlleles::contains), "OriginalAlleles must contain allelesToKeep.");
        int indexOfLast = -1;
        for (Allele a : allelesToKeep) {
            AlleleSubsettingUtils.validateTrue(indexOfLast < originalAlleles.indexOf(a), "alleles to keep must maintain the order of the original alleles.");
            indexOfLast = originalAlleles.indexOf(a);
        }
        int[] allelesIndex = allelesToKeep.stream().mapToInt(originalAlleles::indexOf).toArray();
        GenotypesContext newGTs = GenotypesContext.create(originalGs.size());
        int[] subsettedLikelihoodIndices = AlleleSubsettingUtils.subsettedPLIndices(originalAlleles, allelesToKeep);
        for (Genotype g : originalGs) {
            GenotypeBuilder gb;
            AlleleSubsettingUtils.validateTrue(g.getPloidy() == 2, "only implemented for ploidy 2 for now.");
            int expectedNumLikelihoods = GenotypeLikelihoods.numLikelihoods(allelesToKeep.size(), 2);
            int[] newPLs = null;
            double newLog10GQ = -1.0;
            if (g.hasLikelihoods()) {
                int[] originalPLs = g.getPL();
                if (originalPLs.length != expectedNumLikelihoods) {
                    newPLs = Arrays.stream(subsettedLikelihoodIndices).map(idx -> originalPLs[idx]).toArray();
                    int minLikelihood = MathUtil.min(newPLs);
                    for (int i = 0; i < expectedNumLikelihoods; ++i) {
                        newPLs[i] = newPLs[i] - minLikelihood;
                    }
                    int indexOfMostLikely = MathUtil.indexOfMin(newPLs);
                    newLog10GQ = GenotypeLikelihoods.getGQLog10FromLikelihoods(indexOfMostLikely, GenotypeLikelihoods.fromPLs(newPLs).getAsVector());
                } else {
                    newPLs = null;
                }
            }
            if (newPLs == null) {
                gb = new GenotypeBuilder(g).noPL().noGQ().alleles(DIPLOID_NO_CALL);
            } else {
                gb = new GenotypeBuilder(g).PL(newPLs).log10PError(newLog10GQ);
                List<Integer> originalDiploidAlleles = GenotypeLikelihoods.getAlleles(MathUtil.indexOfMin(newPLs), 2);
                gb.alleles(originalDiploidAlleles.stream().map(allelesToKeep::get).collect(Collectors.toList()));
            }
            if (g.hasAD()) {
                int[] oldAD = g.getAD();
                int[] newAD = IntStream.range(0, allelesToKeep.size()).map(n -> oldAD[allelesIndex[n]]).toArray();
                gb.AD(newAD);
            }
            newGTs.add(gb.make());
        }
        return newGTs;
    }

    public static int[] subsettedPLIndices(List<Allele> originalAlleles, List<Allele> newAlleles) {
        int[] result = new int[GenotypeLikelihoods.numLikelihoods(newAlleles.size(), 2)];
        for (int oldPLIndex = 0; oldPLIndex < GenotypeLikelihoods.numLikelihoods(originalAlleles.size(), 2); ++oldPLIndex) {
            boolean containsOnlyNewAlleles;
            GenotypeLikelihoods.GenotypeLikelihoodsAllelePair allelePairFromPLIndex = GenotypeLikelihoods.getAllelePair(oldPLIndex);
            Allele allele1 = originalAlleles.get(allelePairFromPLIndex.alleleIndex1);
            Allele allele2 = originalAlleles.get(allelePairFromPLIndex.alleleIndex2);
            boolean bl = containsOnlyNewAlleles = newAlleles.contains(allele1) && newAlleles.contains(allele2);
            if (!containsOnlyNewAlleles) continue;
            int newPLIndex = GenotypeLikelihoods.calculatePLindex(newAlleles.indexOf(allele1), newAlleles.indexOf(allele2));
            result[newPLIndex] = oldPLIndex;
        }
        return result;
    }

    private static void validateTrue(boolean condition, String msg) {
        if (!condition) {
            throw new IllegalArgumentException(msg);
        }
    }

    private static <T> T nonNull(T object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
        return object;
    }

    private static <I, T extends Collection<I>> T nonEmpty(T collection, String message) {
        AlleleSubsettingUtils.nonNull(collection, "The collection is null: " + message);
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("The collection is empty: " + message);
        }
        return collection;
    }
}

