/*
 * Decompiled with CFR 0.152.
 */
package picard.pedigree;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import picard.PicardException;

public enum Sex {
    Male("M", 1),
    Female("F", 2),
    Unknown("U", -9),
    NotReported("N", -9);

    private final int code;
    private final String symbol;

    private Sex(String symbol, int code) {
        this.code = code;
        this.symbol = symbol;
    }

    public int toCode() {
        return this.code;
    }

    public static Sex fromCode(int code) {
        if (code == Sex.Male.code) {
            return Male;
        }
        if (code == Sex.Female.code) {
            return Female;
        }
        return Unknown;
    }

    public String toSymbol() {
        return this.symbol;
    }

    public static Sex fromString(String sexString) {
        Predicate<Sex> match = g -> sexString.equalsIgnoreCase(g.symbol) || sexString.equalsIgnoreCase(g.name());
        List genders = Stream.of(Sex.values()).filter(match).collect(Collectors.toList());
        if (genders.size() == 1) {
            return (Sex)((Object)genders.get(0));
        }
        throw new PicardException("Unrecognized Sex string: " + sexString);
    }
}

