/*
 * Decompiled with CFR 0.152.
 */
package picard.arrays.illumina;

import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import picard.PicardException;
import picard.arrays.illumina.IlluminaManifestRecord;
import picard.util.CsvInputParser;

public class IlluminaManifest {
    public static final String HG17 = "HG17";
    public static final String HG18 = "HG18";
    public static final String HG19 = "HG19";
    public static final String NCBI_35 = "35";
    public static final String NCBI_36 = "36";
    public static final String NCBI_37 = "37";
    public static final BidiMap HG_TO_NCBI = new DualHashBidiMap();
    private static final String[] ALLELES_LIST;
    public static final HashSet<String> VALID_ALLELES;
    public static final String ILLUMINA_ID_HEADER_NAME = "IlmnID";
    public static final String NAME_HEADER_NAME = "Name";
    public static final String ILLUMINA_STRAND_HEADER_NAME = "IlmnStrand";
    public static final String SNP_HEADER_NAME = "SNP";
    public static final String ADDRESS_A_ID_HEADER_NAME = "AddressA_ID";
    public static final String ALLELE_A_PROBE_SEQ_HEADER_NAME = "AlleleA_ProbeSeq";
    public static final String ADDRESS_B_ID_HEADER_NAME = "AddressB_ID";
    public static final String ALLELE_B_PROBE_SEQ_HEADER_NAME = "AlleleB_ProbeSeq";
    public static final String GENOME_BUILD_HEADER_NAME = "GenomeBuild";
    public static final String CHROMOSOME_HEADER_NAME = "Chr";
    public static final String MAP_INFO_HEADER_NAME = "MapInfo";
    public static final String PLOIDY_HEADER_NAME = "Ploidy";
    public static final String SPECIES_HEADER_NAME = "Species";
    public static final String SOURCE_HEADER_NAME = "Source";
    public static final String SOURCE_VERSION_HEADER_NAME = "SourceVersion";
    public static final String SOURCE_STRAND_HEADER_NAME = "SourceStrand";
    public static final String SOURCE_SEQ_HEADER_NAME = "SourceSeq";
    public static final String TOP_GENOMIC_SEQ_HEADER_NAME = "TopGenomicSeq";
    public static final String BEAD_SET_ID_HEADER_NAME = "BeadSetID";
    public static final String EXP_CLUSTERS_HEADER_NAME = "Exp_Clusters";
    public static final String REF_STRAND_HEADER_NAME = "RefStrand";
    public static final String INTENSITY_ONLY_HEADER_NAME = "Intensity_Only";
    public static final String[] MANIFEST_FILE_HEADER_NAMES;
    public static final HashSet<String> HEADER_NAMES;
    private final Log log = Log.getInstance(IlluminaManifest.class);
    private final File manifestFile;
    private final List<String[]> headerContents = new ArrayList<String[]>();
    protected CsvInputParser manifestFileParser;
    private String descriptorFileName;
    private String assayFormat;
    private String dateManufactured;
    private int lociCount;
    private int numAssays;
    private String[] assayHeaderNames;
    private Map<String, Integer> assayHeaderNameToIndex;

    public String[] getAllPossibleHeaderNames() {
        return MANIFEST_FILE_HEADER_NAMES;
    }

    public String[] getAssayHeaderNames() {
        return this.assayHeaderNames;
    }

    public Map<String, Integer> getAssayHeaderNameToIndex() {
        return this.assayHeaderNameToIndex;
    }

    public IlluminaManifest(File manifestFile) throws IOException {
        IOUtil.assertFileIsReadable(manifestFile);
        this.manifestFile = manifestFile;
        this.readHeader();
        this.setNumAssays(this.lociCount);
        this.init();
    }

    public IlluminaManifest(File manifestFile, int numAssays) throws IOException {
        IOUtil.assertFileIsReadable(manifestFile);
        this.manifestFile = manifestFile;
        this.readHeader();
        this.setNumAssays(numAssays);
        this.init();
    }

    private void init() throws IOException {
        FileInputStream fileInputStream = new FileInputStream(this.getManifestFile());
        this.advanceDataStream(fileInputStream, "[Assay]");
        String headerLine = this.readLineFromStream(fileInputStream);
        this.validateManifestRecordHeader(headerLine);
        this.manifestFileParser = new CsvInputParser(false, fileInputStream);
    }

    public Iterator<IlluminaManifestRecord> iterator() {
        return new Iterator<IlluminaManifestRecord>(){
            private int assayCount = 0;
            private int numAssays = IlluminaManifest.this.getNumAssays();
            private boolean firstCall = true;
            private String[] nextLine = null;

            @Override
            public boolean hasNext() {
                if (this.firstCall) {
                    this.firstCall = false;
                    this.nextLine = (String[])IlluminaManifest.this.manifestFileParser.next();
                }
                return this.assayCount < this.numAssays && this.nextLine != null && IlluminaManifestRecord.isValidManifestRecordLine(IlluminaManifest.this.assayHeaderNames.length, this.nextLine);
            }

            @Override
            public IlluminaManifestRecord next() {
                String[] currentLine = this.nextLine;
                ++this.assayCount;
                this.nextLine = IlluminaManifest.this.manifestFileParser.hasNext() ? (String[])IlluminaManifest.this.manifestFileParser.next() : null;
                return new IlluminaManifestRecord(IlluminaManifest.this.assayHeaderNameToIndex, currentLine, this.assayCount - 1);
            }
        };
    }

    private void readHeader() throws IOException {
        FileInputStream fileInputStream = new FileInputStream(this.getManifestFile());
        this.manifestFileParser = new CsvInputParser(false, fileInputStream);
        boolean inHeader = true;
        while (this.manifestFileParser.hasNext()) {
            String tagName;
            String[] row = (String[])this.manifestFileParser.next();
            this.headerContents.add(row);
            switch (tagName = row[0].trim()) {
                case "Descriptor File Name": {
                    this.setDescriptorFileName(row[1]);
                    break;
                }
                case "Assay Format": {
                    this.setAssayFormat(row[1]);
                    break;
                }
                case "Date Manufactured": {
                    this.setDateManufactured(row[1]);
                    break;
                }
                case "Loci Count": {
                    this.setLociCount(new Integer(row[1]));
                    inHeader = false;
                }
            }
            if (inHeader) continue;
            break;
        }
        fileInputStream.close();
    }

    private void validateManifestRecordHeader(String line) throws PicardException {
        String[] columns = line.trim().split(",");
        HashMap<String, Integer> columnNameToIndex = new HashMap<String, Integer>();
        int index = 0;
        HashSet<String> validHeaderNames = new HashSet<String>(Arrays.asList(this.getAllPossibleHeaderNames()));
        for (String columnName : columns) {
            if (!validHeaderNames.contains(columnName)) {
                throw new PicardException("Unrecognized Column '" + columnName + "' in Manifest file: " + this.manifestFile);
            }
            columnNameToIndex.put(columnName, index++);
        }
        if (!columnNameToIndex.containsKey(REF_STRAND_HEADER_NAME)) {
            this.log.warn("Illumina Manifest does not contain 'RefStrand' - we will use 'IlmnStrand'");
        }
        this.assayHeaderNames = columns;
        this.assayHeaderNameToIndex = columnNameToIndex;
    }

    public String[] getManifestFileHeaderNames() {
        return this.assayHeaderNames;
    }

    private void advanceDataStream(FileInputStream inputStream, String sectionName) throws IOException {
        String line;
        while (!(line = this.readLineFromStream(inputStream).trim()).contains(sectionName)) {
        }
    }

    private String readLineFromStream(InputStream inputStream) throws IOException {
        int ch;
        StringBuilder sb = new StringBuilder();
        while ((ch = inputStream.read()) > -1 && ch != 10) {
            sb.append((char)ch);
        }
        if (ch == -1) {
            throw new PicardException("Unexpected end of file");
        }
        return sb.toString();
    }

    public File getManifestFile() {
        return this.manifestFile;
    }

    public CsvInputParser getManifestFileParser() {
        return this.manifestFileParser;
    }

    public void setManifestFileParser(CsvInputParser manifestFileParser) {
        this.manifestFileParser = manifestFileParser;
    }

    public String getDescriptorFileName() {
        return this.descriptorFileName;
    }

    public void setDescriptorFileName(String descriptorFileName) {
        this.descriptorFileName = descriptorFileName;
    }

    public String getAssayFormat() {
        return this.assayFormat;
    }

    public void setAssayFormat(String assayFormat) {
        this.assayFormat = assayFormat;
    }

    public String getDateManufactured() {
        return this.dateManufactured;
    }

    public void setDateManufactured(String dateManufactured) {
        this.dateManufactured = dateManufactured;
    }

    public void setLociCount(int lociCount) {
        this.lociCount = lociCount;
    }

    public int getLociCount() {
        return this.lociCount;
    }

    public int getNumAssays() {
        return this.numAssays;
    }

    public void setNumAssays(int numAssays) {
        this.numAssays = numAssays;
    }

    public List<String[]> getHeaderContents() {
        return this.headerContents;
    }

    static {
        HG_TO_NCBI.put(HG17, NCBI_35);
        HG_TO_NCBI.put(HG18, NCBI_36);
        HG_TO_NCBI.put(HG19, NCBI_37);
        ALLELES_LIST = new String[]{"A", "C", "G", "T", "I", "D"};
        VALID_ALLELES = new HashSet<String>(Arrays.asList(ALLELES_LIST));
        MANIFEST_FILE_HEADER_NAMES = new String[]{ILLUMINA_ID_HEADER_NAME, NAME_HEADER_NAME, ILLUMINA_STRAND_HEADER_NAME, SNP_HEADER_NAME, ADDRESS_A_ID_HEADER_NAME, ALLELE_A_PROBE_SEQ_HEADER_NAME, ADDRESS_B_ID_HEADER_NAME, ALLELE_B_PROBE_SEQ_HEADER_NAME, GENOME_BUILD_HEADER_NAME, CHROMOSOME_HEADER_NAME, MAP_INFO_HEADER_NAME, PLOIDY_HEADER_NAME, SPECIES_HEADER_NAME, SOURCE_HEADER_NAME, SOURCE_VERSION_HEADER_NAME, SOURCE_STRAND_HEADER_NAME, SOURCE_SEQ_HEADER_NAME, TOP_GENOMIC_SEQ_HEADER_NAME, BEAD_SET_ID_HEADER_NAME, EXP_CLUSTERS_HEADER_NAME, REF_STRAND_HEADER_NAME, INTENSITY_ONLY_HEADER_NAME};
        HEADER_NAMES = new HashSet<String>(Arrays.asList(MANIFEST_FILE_HEADER_NAMES));
    }
}

