/*
 * Decompiled with CFR 0.152.
 */
package picard.arrays;

import htsjdk.samtools.util.IOUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Map;
import picard.PicardException;

class ZCallPedFile {
    private static final int OFFSET = 6;
    private final Map<String, String> snpToAlleleMap = new HashMap<String, String>();

    ZCallPedFile() {
    }

    private void addAllele(String snp, String allele) {
        this.snpToAlleleMap.put(snp, allele);
    }

    String getAlleles(String snp) {
        return this.snpToAlleleMap.get(snp);
    }

    public static ZCallPedFile fromFile(File pedFile, File mapFile) throws FileNotFoundException {
        String[] pedFileLines = IOUtil.slurpLines(pedFile).toArray(new String[0]);
        if (pedFileLines.length > 1) {
            throw new PicardException("Only single-sample .ped files are supported.");
        }
        String[] pedFileFields = IOUtil.slurp(pedFile).split("\\s");
        String[] mapFileLines = IOUtil.slurpLines(mapFile).toArray(new String[0]);
        ZCallPedFile zCallPedFile = new ZCallPedFile();
        for (int i = 0; i < mapFileLines.length; ++i) {
            int index = i * 2 + 6;
            if (pedFileFields[index].length() != 1 || pedFileFields[index + 1].length() != 1) {
                throw new PicardException("Malformed file: each allele should be a single character.");
            }
            String alleles = pedFileFields[index] + pedFileFields[index + 1];
            zCallPedFile.addAllele(mapFileLines[i].split("\\s")[1], alleles);
        }
        return zCallPedFile;
    }
}

