/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis.artifacts;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.ListMap;
import htsjdk.samtools.util.SequenceUtil;
import htsjdk.samtools.util.StringUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import picard.PicardException;
import picard.analysis.artifacts.SequencingArtifactMetrics;
import picard.analysis.artifacts.Transition;

class ContextAccumulator {
    private final boolean expectedTandemReads;
    private final Map<String, AlignmentAccumulator[]> artifactMap;

    public ContextAccumulator(Set<String> contexts, boolean expectedTandemReads) {
        this.expectedTandemReads = expectedTandemReads;
        this.artifactMap = new HashMap<String, AlignmentAccumulator[]>();
        for (String context : contexts) {
            if ((context.length() & 1) == 0) {
                throw new PicardException("Contexts cannot have an even number of bases: " + context);
            }
            AlignmentAccumulator[] accumulators = new AlignmentAccumulator[Transition.Base.values().length];
            for (int i = 0; i < Transition.Base.values().length; ++i) {
                accumulators[i] = new AlignmentAccumulator();
            }
            this.artifactMap.put(context, accumulators);
        }
    }

    public void countRecord(String refContext, char calledBase, SAMRecord rec) {
        AlignmentAccumulator[] accumulators = this.artifactMap.get(refContext);
        if (accumulators != null) {
            accumulators[Transition.baseIndexMap[calledBase]].countRecord(rec);
        }
    }

    public void fillHalfRecords(ContextAccumulator fullContextAccumulator, int contextSize) {
        String padding = StringUtil.repeatCharNTimes('N', contextSize);
        for (Map.Entry<String, AlignmentAccumulator[]> fullContext : fullContextAccumulator.artifactMap.entrySet()) {
            String fullContextKey = fullContext.getKey();
            char centralBase = fullContextKey.charAt(contextSize);
            String leadingContextKey = fullContextKey.substring(0, contextSize) + centralBase + padding;
            String trailingContextKey = padding + centralBase + fullContextKey.substring(contextSize + 1, fullContextKey.length());
            AlignmentAccumulator[] trailingAlignmentAccumulators = this.artifactMap.get(trailingContextKey);
            AlignmentAccumulator[] leadingAlignmentAccumulators = this.artifactMap.get(leadingContextKey);
            AlignmentAccumulator[] fullAlignmentAccumulators = fullContext.getValue();
            for (int i = 0; i < fullAlignmentAccumulators.length; ++i) {
                trailingAlignmentAccumulators[i].merge(fullAlignmentAccumulators[i]);
                leadingAlignmentAccumulators[i].merge(fullAlignmentAccumulators[i]);
            }
        }
    }

    public void fillZeroRecords(ContextAccumulator fullContextAccumulator, int contextSize) {
        String padding = StringUtil.repeatCharNTimes('N', contextSize);
        for (Map.Entry<String, AlignmentAccumulator[]> fullContext : fullContextAccumulator.artifactMap.entrySet()) {
            String fullContextKey = fullContext.getKey();
            char centralBase = fullContextKey.charAt(contextSize);
            String zeroContextKey = padding + centralBase + padding;
            AlignmentAccumulator[] zeroAlignmentAccumulators = this.artifactMap.get(zeroContextKey);
            AlignmentAccumulator[] fullAlignmentAccumulators = fullContext.getValue();
            for (int i = 0; i < fullAlignmentAccumulators.length; ++i) {
                zeroAlignmentAccumulators[i].merge(fullAlignmentAccumulators[i]);
            }
        }
    }

    public ListMap<Transition, SequencingArtifactMetrics.DetailPair> calculateMetrics(String sampleAlias, String library) {
        ListMap<Transition, SequencingArtifactMetrics.DetailPair> detailMetricsMap = new ListMap<Transition, SequencingArtifactMetrics.DetailPair>();
        for (String context : new TreeSet<String>(this.artifactMap.keySet())) {
            if ((context.length() & 1) == 0) {
                throw new PicardException("Contexts cannot have an even number of bases: " + context + ".  This should never happen here!");
            }
            char refBase = context.charAt(context.length() / 2);
            for (Transition.Base altBase : Transition.Base.values()) {
                Transition transition = Transition.transitionOf(refBase, (char)altBase.base);
                SequencingArtifactMetrics.PreAdapterDetailMetrics preAdapterDetailMetrics = new SequencingArtifactMetrics.PreAdapterDetailMetrics();
                SequencingArtifactMetrics.BaitBiasDetailMetrics baitBiasDetailMetrics = new SequencingArtifactMetrics.BaitBiasDetailMetrics();
                preAdapterDetailMetrics.SAMPLE_ALIAS = sampleAlias;
                preAdapterDetailMetrics.LIBRARY = library;
                preAdapterDetailMetrics.CONTEXT = context;
                preAdapterDetailMetrics.REF_BASE = transition.ref();
                preAdapterDetailMetrics.ALT_BASE = transition.call();
                baitBiasDetailMetrics.SAMPLE_ALIAS = sampleAlias;
                baitBiasDetailMetrics.LIBRARY = library;
                baitBiasDetailMetrics.CONTEXT = context;
                baitBiasDetailMetrics.REF_BASE = transition.ref();
                baitBiasDetailMetrics.ALT_BASE = transition.call();
                AlignmentAccumulator[] accumulators = this.artifactMap.get(context);
                AlignmentAccumulator[] reverseCompAccumulators = this.artifactMap.get(SequenceUtil.reverseComplement(context));
                AlignmentAccumulator fwdRefAlignments = accumulators[Transition.baseIndexMap[transition.ref()]];
                AlignmentAccumulator fwdAltAlignments = accumulators[Transition.baseIndexMap[transition.call()]];
                AlignmentAccumulator revRefAlignments = reverseCompAccumulators[Transition.baseIndexMap[transition.complement().ref()]];
                AlignmentAccumulator revAltAlignments = reverseCompAccumulators[Transition.baseIndexMap[transition.complement().call()]];
                if (this.expectedTandemReads) {
                    preAdapterDetailMetrics.PRO_REF_BASES = fwdRefAlignments.R1_POS + fwdRefAlignments.R2_POS + revRefAlignments.R1_NEG + revRefAlignments.R2_NEG;
                    preAdapterDetailMetrics.PRO_ALT_BASES = fwdAltAlignments.R1_POS + fwdAltAlignments.R2_POS + revAltAlignments.R1_NEG + revAltAlignments.R2_NEG;
                    preAdapterDetailMetrics.CON_REF_BASES = fwdRefAlignments.R1_NEG + fwdRefAlignments.R2_NEG + revRefAlignments.R1_POS + revRefAlignments.R2_POS;
                    preAdapterDetailMetrics.CON_ALT_BASES = fwdAltAlignments.R1_NEG + fwdAltAlignments.R2_NEG + revAltAlignments.R1_POS + revAltAlignments.R2_POS;
                } else {
                    preAdapterDetailMetrics.PRO_REF_BASES = fwdRefAlignments.R1_POS + fwdRefAlignments.R2_NEG + revRefAlignments.R1_NEG + revRefAlignments.R2_POS;
                    preAdapterDetailMetrics.PRO_ALT_BASES = fwdAltAlignments.R1_POS + fwdAltAlignments.R2_NEG + revAltAlignments.R1_NEG + revAltAlignments.R2_POS;
                    preAdapterDetailMetrics.CON_REF_BASES = fwdRefAlignments.R1_NEG + fwdRefAlignments.R2_POS + revRefAlignments.R1_POS + revRefAlignments.R2_NEG;
                    preAdapterDetailMetrics.CON_ALT_BASES = fwdAltAlignments.R1_NEG + fwdAltAlignments.R2_POS + revAltAlignments.R1_POS + revAltAlignments.R2_NEG;
                }
                baitBiasDetailMetrics.FWD_CXT_REF_BASES = fwdRefAlignments.R1_POS + fwdRefAlignments.R1_NEG + fwdRefAlignments.R2_POS + fwdRefAlignments.R2_NEG;
                baitBiasDetailMetrics.FWD_CXT_ALT_BASES = fwdAltAlignments.R1_POS + fwdAltAlignments.R1_NEG + fwdAltAlignments.R2_POS + fwdAltAlignments.R2_NEG;
                baitBiasDetailMetrics.REV_CXT_REF_BASES = revRefAlignments.R1_POS + revRefAlignments.R1_NEG + revRefAlignments.R2_POS + revRefAlignments.R2_NEG;
                baitBiasDetailMetrics.REV_CXT_ALT_BASES = revAltAlignments.R1_POS + revAltAlignments.R1_NEG + revAltAlignments.R2_POS + revAltAlignments.R2_NEG;
                preAdapterDetailMetrics.calculateDerivedStatistics();
                baitBiasDetailMetrics.calculateDerivedStatistics();
                detailMetricsMap.add(transition, new SequencingArtifactMetrics.DetailPair(preAdapterDetailMetrics, baitBiasDetailMetrics));
            }
        }
        return detailMetricsMap;
    }

    private static class AlignmentAccumulator {
        private long R1_POS = 0L;
        private long R1_NEG = 0L;
        private long R2_POS = 0L;
        private long R2_NEG = 0L;

        private AlignmentAccumulator() {
        }

        private void countRecord(SAMRecord rec) {
            boolean isReadTwo;
            boolean isNegativeStrand = rec.getReadNegativeStrandFlag();
            boolean bl = isReadTwo = rec.getReadPairedFlag() && rec.getSecondOfPairFlag();
            if (isReadTwo) {
                if (isNegativeStrand) {
                    ++this.R2_NEG;
                } else {
                    ++this.R2_POS;
                }
            } else if (isNegativeStrand) {
                ++this.R1_NEG;
            } else {
                ++this.R1_POS;
            }
        }

        private void merge(AlignmentAccumulator other) {
            this.R1_POS += other.R1_POS;
            this.R2_POS += other.R2_POS;
            this.R1_NEG += other.R1_NEG;
            this.R2_NEG += other.R2_NEG;
        }
    }
}

