/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.SequenceUtil;
import htsjdk.samtools.util.StringUtil;
import java.util.HashSet;
import java.util.List;
import picard.util.IlluminaUtil;

public class AdapterUtility {
    private static final int ADAPTER_MATCH_LENGTH = 16;
    private static final int MAX_ADAPTER_ERRORS = 1;
    final byte[][] adapterKmers;
    public static List<String> DEFAULT_ADAPTER_SEQUENCE = CollectionUtil.makeList(IlluminaUtil.IlluminaAdapterPair.SINGLE_END.get5PrimeAdapter(), IlluminaUtil.IlluminaAdapterPair.SINGLE_END.get3PrimeAdapter(), IlluminaUtil.IlluminaAdapterPair.PAIRED_END.get5PrimeAdapter(), IlluminaUtil.IlluminaAdapterPair.PAIRED_END.get3PrimeAdapter(), IlluminaUtil.IlluminaAdapterPair.INDEXED.get5PrimeAdapter(), IlluminaUtil.IlluminaAdapterPair.INDEXED.get3PrimeAdapter());

    public AdapterUtility(List<String> adapterSequence) {
        this.adapterKmers = AdapterUtility.prepareAdapterSequences(adapterSequence);
    }

    private static byte[][] prepareAdapterSequences(List<String> adapterSequence) {
        HashSet<String> kmers = new HashSet<String>();
        for (String seq : adapterSequence) {
            for (int i = 0; i <= seq.length() - 16; ++i) {
                String kmer = seq.substring(i, i + 16).toUpperCase();
                int ns = 0;
                for (char ch : kmer.toCharArray()) {
                    if (ch != 'N') continue;
                    ++ns;
                }
                if (ns > true) continue;
                kmers.add(kmer);
                kmers.add(SequenceUtil.reverseComplement(kmer));
            }
        }
        byte[][] adapterKmers = new byte[kmers.size()][];
        int i = 0;
        for (String kmer : kmers) {
            adapterKmers[i++] = StringUtil.stringToBytes(kmer);
        }
        return adapterKmers;
    }

    public boolean isAdapter(SAMRecord record) {
        if (!record.getReadUnmappedFlag() && record.getMappingQuality() != 0) {
            return false;
        }
        boolean revComp = !record.getReadUnmappedFlag() && record.getReadNegativeStrandFlag();
        byte[] readBases = record.getReadBases();
        return this.isAdapterSequence(readBases, revComp);
    }

    public boolean isAdapterSequence(byte[] read, boolean revCompRead) {
        if (read.length < 16) {
            return false;
        }
        for (byte[] adapter : this.adapterKmers) {
            int errors = 0;
            for (int i = 0; i < adapter.length; ++i) {
                byte base;
                byte by = base = revCompRead ? SequenceUtil.complement(read[read.length - i - 1]) : read[i];
                if (!SequenceUtil.basesEqual(base, adapter[i]) && ++errors > 1) break;
            }
            if (errors > true) continue;
            return true;
        }
        return false;
    }

    public boolean isAdapterSequence(byte[] read) {
        return this.isAdapterSequence(read, false);
    }
}

