/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.barclay.argparser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.broadinstitute.barclay.argparser.CommandLineException;
import org.broadinstitute.barclay.argparser.TaggedArgument;
import org.broadinstitute.barclay.utils.Utils;

public final class TaggedArgumentParser {
    private static final String ARGUMENT_KEY_VALUE_PAIR_DELIMITER = ",";
    private static final String ARGUMENT_KEY_VALUE_SEPARATOR = "=";
    private static final char ARGUMENT_TAG_NAME_SEPARATOR = ':';
    private static final String USAGE = "Tagged arguments must be of the form argument_name or argument_name:logical_name(,key=value)*";
    private Map<String, Pair<String, String>> tagSurrogates = new HashMap<String, Pair<String, String>>();
    private static final String SHORT_OPTION_PREFIX = "-";
    private static final String LONG_OPTION_PREFIX = "--";

    public String[] preprocessTaggedOptions(String[] argArray) {
        ArrayList<String> finalArgs = new ArrayList<String>(argArray.length);
        Iterator<String> argIt = Arrays.asList(argArray).iterator();
        while (argIt.hasNext()) {
            String arg = argIt.next();
            if (TaggedArgumentParser.isShortOptionToken(arg)) {
                this.replaceTaggedOption(SHORT_OPTION_PREFIX, arg.substring(SHORT_OPTION_PREFIX.length()), argIt, finalArgs);
                continue;
            }
            if (TaggedArgumentParser.isLongOptionToken(arg)) {
                this.replaceTaggedOption(LONG_OPTION_PREFIX, arg.substring(LONG_OPTION_PREFIX.length()), argIt, finalArgs);
                continue;
            }
            finalArgs.add(arg);
        }
        return finalArgs.toArray(new String[finalArgs.size()]);
    }

    public void resetTagSurrogates() {
        this.tagSurrogates.clear();
    }

    private void replaceTaggedOption(String optionPrefix, String optionString, Iterator<String> userArgIt, List<String> finalArgList) {
        int separatorIndex = optionString.indexOf(58);
        if (separatorIndex == -1) {
            this.detectAndRejectHybridSyntax(optionString);
            finalArgList.add(optionPrefix + optionString);
        } else {
            String optionName = optionString.substring(0, separatorIndex);
            this.detectAndRejectHybridSyntax(optionName);
            if (userArgIt.hasNext()) {
                if (optionName.isEmpty()) {
                    throw new CommandLineException("Zero length argument name found in tagged argument: " + optionString);
                }
                String tagNameAndValues = optionString.substring(separatorIndex + 1, optionString.length());
                if (tagNameAndValues.isEmpty()) {
                    throw new CommandLineException("Zero length tag name found in tagged argument: " + optionString);
                }
                String argValue = userArgIt.next();
                if (TaggedArgumentParser.isLongOptionToken(argValue) || TaggedArgumentParser.isShortOptionToken(argValue)) {
                    throw new CommandLineException("No argument value found for tagged argument: " + optionString);
                }
                String pairKey = this.getSurrogateKeyForTaggedOption(optionString, argValue, tagNameAndValues);
                finalArgList.add(optionPrefix + optionName);
                finalArgList.add(pairKey);
            } else {
                throw new CommandLineException("No argument value found for tagged argument: " + optionString);
            }
        }
    }

    private void detectAndRejectHybridSyntax(String optionName) {
        if (optionName.contains(ARGUMENT_KEY_VALUE_SEPARATOR)) {
            throw new CommandLineException(String.format("Can't parse option name containing an embedded '=' (%s)", optionName));
        }
    }

    public Pair<String, String> getTaggedOptionForSurrogate(String putativeSurrogateKey) {
        return this.tagSurrogates.get(putativeSurrogateKey);
    }

    private static boolean isShortOptionToken(String argument) {
        return argument.startsWith(SHORT_OPTION_PREFIX) && !SHORT_OPTION_PREFIX.equals(argument) && !TaggedArgumentParser.isLongOptionToken(argument);
    }

    private static boolean isLongOptionToken(String argument) {
        return argument.startsWith(LONG_OPTION_PREFIX);
    }

    private String getSurrogateKeyForTaggedOption(String rawOptionString, String rawArgumentValue, String tagString) {
        String surrogateKey = this.makeSurrogateKey(rawOptionString, rawArgumentValue);
        if (null != this.tagSurrogates.put(surrogateKey, Pair.of(tagString, rawArgumentValue))) {
            throw new CommandLineException.BadArgumentValue(String.format("The argument value: \"%s %s\" was duplicated on the command line", rawOptionString, rawArgumentValue));
        }
        return surrogateKey;
    }

    private String makeSurrogateKey(String rawOptionString, String rawArgumentValue) {
        return rawOptionString + ':' + rawArgumentValue;
    }

    public static void populateArgumentTags(TaggedArgument taggedArg, String longArgName, String tagString) {
        if (tagString == null) {
            taggedArg.setTag(null);
            taggedArg.setTagAttributes(Collections.emptyMap());
        } else {
            ParsedArgument pa = ParsedArgument.of(longArgName, tagString);
            taggedArg.setTag(pa.getName());
            taggedArg.setTagAttributes(pa.keyValueMap());
        }
    }

    public static String getDisplayString(String longArgName, TaggedArgument taggedArg) {
        Utils.nonNull(longArgName);
        Utils.nonNull(taggedArg);
        StringBuilder sb = new StringBuilder();
        sb.append(longArgName);
        if (taggedArg.getTag() != null) {
            sb.append(':');
            sb.append(taggedArg.getTag());
            if (taggedArg.getTagAttributes() != null) {
                taggedArg.getTagAttributes().entrySet().stream().forEach(entry -> {
                    sb.append(ARGUMENT_KEY_VALUE_PAIR_DELIMITER);
                    sb.append(((String)entry.getKey()).toString());
                    sb.append(ARGUMENT_KEY_VALUE_SEPARATOR);
                    sb.append(((String)entry.getValue()).toString());
                });
            }
        }
        return sb.toString();
    }

    private static final class ParsedArgument {
        private final String name;
        private final Map<String, String> keyValueMap;

        public static ParsedArgument of(String longArgName, String rawTagValue) {
            String[] tokens = rawTagValue.split(TaggedArgumentParser.ARGUMENT_KEY_VALUE_PAIR_DELIMITER, -1);
            if (tokens.length == 0) {
                throw new CommandLineException.BadArgumentValue(longArgName, rawTagValue, TaggedArgumentParser.USAGE);
            }
            if (tokens[0].contains(TaggedArgumentParser.ARGUMENT_KEY_VALUE_SEPARATOR)) {
                throw new CommandLineException.BadArgumentValue("Missing tag name for argument: " + rawTagValue);
            }
            if (Arrays.stream(tokens).anyMatch(String::isEmpty)) {
                throw new CommandLineException.BadArgumentValue(longArgName, rawTagValue, "Empty tag or attribute encountered. Tagged arguments must be of the form argument_name or argument_name:logical_name(,key=value)*");
            }
            ParsedArgument pa = new ParsedArgument(tokens[0]);
            if (tokens.length == 1) {
                return pa;
            }
            for (int i = 1; i < tokens.length; ++i) {
                String[] kv = tokens[i].split(TaggedArgumentParser.ARGUMENT_KEY_VALUE_SEPARATOR, -1);
                if (kv.length != 2 || kv[0].isEmpty() || kv[1].isEmpty()) {
                    throw new CommandLineException.BadArgumentValue("", rawTagValue, TaggedArgumentParser.USAGE);
                }
                if (pa.containsKey(kv[0])) {
                    throw new CommandLineException.BadArgumentValue("", rawTagValue, "Duplicate key " + kv[0] + "\n" + TaggedArgumentParser.USAGE);
                }
                pa.addKeyValue(kv[0], kv[1]);
            }
            return pa;
        }

        private ParsedArgument(String name) {
            this.name = name;
            this.keyValueMap = new LinkedHashMap<String, String>(2);
        }

        public String getName() {
            return this.name;
        }

        public Map<String, String> keyValueMap() {
            return Collections.unmodifiableMap(this.keyValueMap);
        }

        public void addKeyValue(String k, String v) {
            this.keyValueMap.put(k, v);
        }

        private boolean containsKey(String k) {
            return this.keyValueMap.containsKey(k);
        }
    }
}

