/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.variantcontext;

import htsjdk.tribble.TribbleException;
import htsjdk.variant.utils.BinomialCoefficientUtil;
import htsjdk.variant.utils.GeneralUtils;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypeNumLikelihoodsCache;
import htsjdk.variant.variantcontext.GenotypeType;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GenotypeLikelihoods {
    private static final GenotypeNumLikelihoodsCache numLikelihoodCache = new GenotypeNumLikelihoodsCache();
    public static final int MAX_PL = Integer.MAX_VALUE;
    private double[] log10Likelihoods = null;
    private String likelihoodsAsString_PLs = null;
    public static final int MAX_DIPLOID_ALT_ALLELES_THAT_CAN_BE_GENOTYPED = 50;
    private static final GenotypeLikelihoodsAllelePair[] diploidPLIndexToAlleleIndex = GenotypeLikelihoods.calculateDiploidPLcache(50);
    protected static final Map<Integer, List<List<Integer>>> anyploidPloidyToPLIndexToAlleleIndices = new HashMap<Integer, List<List<Integer>>>();
    protected static final int[] PLindexConversion = new int[]{0, 1, 3, 6, 2, 4, 7, 5, 8, 9};

    public static final GenotypeLikelihoods fromPLField(String PLs) {
        return new GenotypeLikelihoods(PLs);
    }

    @Deprecated
    public static final GenotypeLikelihoods fromGLField(String GLs) {
        return new GenotypeLikelihoods(GenotypeLikelihoods.parseDeprecatedGLString(GLs));
    }

    public static final GenotypeLikelihoods fromLog10Likelihoods(double[] log10Likelihoods) {
        return new GenotypeLikelihoods(log10Likelihoods);
    }

    public static final GenotypeLikelihoods fromPLs(int[] pls) {
        return new GenotypeLikelihoods(GenotypeLikelihoods.PLsToGLs(pls));
    }

    private GenotypeLikelihoods(String asString) {
        this.likelihoodsAsString_PLs = asString;
    }

    private GenotypeLikelihoods(double[] asVector) {
        this.log10Likelihoods = asVector;
    }

    public double[] getAsVector() {
        if (this.log10Likelihoods == null) {
            this.log10Likelihoods = GenotypeLikelihoods.parsePLsIntoLikelihoods(this.likelihoodsAsString_PLs);
        }
        return this.log10Likelihoods;
    }

    public int[] getAsPLs() {
        double[] GLs = this.getAsVector();
        return GLs == null ? null : GenotypeLikelihoods.GLsToPLs(GLs);
    }

    public String toString() {
        return this.getAsString();
    }

    public String getAsString() {
        if (this.likelihoodsAsString_PLs == null) {
            if (this.log10Likelihoods == null) {
                throw new TribbleException("BUG: Attempted to get likelihoods as strings and neither the vector nor the string is set!");
            }
            this.likelihoodsAsString_PLs = GenotypeLikelihoods.convertLikelihoodsToPLString(this.log10Likelihoods);
        }
        return this.likelihoodsAsString_PLs;
    }

    public boolean equals(Object aThat) {
        if (this == aThat) {
            return true;
        }
        if (!(aThat instanceof GenotypeLikelihoods)) {
            return false;
        }
        GenotypeLikelihoods that = (GenotypeLikelihoods)aThat;
        return Arrays.equals(this.getAsPLs(), that.getAsPLs());
    }

    public int hashCode() {
        return Arrays.hashCode(this.getAsPLs());
    }

    public EnumMap<GenotypeType, Double> getAsMap(boolean normalizeFromLog10) {
        double[] likelihoods;
        double[] dArray = likelihoods = normalizeFromLog10 ? GeneralUtils.normalizeFromLog10(this.getAsVector()) : this.getAsVector();
        if (likelihoods == null) {
            return null;
        }
        EnumMap<GenotypeType, Double> likelihoodsMap = new EnumMap<GenotypeType, Double>(GenotypeType.class);
        likelihoodsMap.put(GenotypeType.HOM_REF, likelihoods[GenotypeType.HOM_REF.ordinal() - 1]);
        likelihoodsMap.put(GenotypeType.HET, likelihoods[GenotypeType.HET.ordinal() - 1]);
        likelihoodsMap.put(GenotypeType.HOM_VAR, likelihoods[GenotypeType.HOM_VAR.ordinal() - 1]);
        return likelihoodsMap;
    }

    @Deprecated
    public double getLog10GQ(GenotypeType genotype) {
        return GenotypeLikelihoods.getGQLog10FromLikelihoods(genotype.ordinal() - 1, this.getAsVector());
    }

    private double getLog10GQ(List<Allele> genotypeAlleles, List<Allele> contextAlleles) {
        int allele1Index = contextAlleles.indexOf(genotypeAlleles.get(0));
        int allele2Index = contextAlleles.indexOf(genotypeAlleles.get(1));
        int plIndex = GenotypeLikelihoods.calculatePLindex(allele1Index, allele2Index);
        return GenotypeLikelihoods.getGQLog10FromLikelihoods(plIndex, this.getAsVector());
    }

    public double getLog10GQ(Genotype genotype, List<Allele> vcAlleles) {
        return this.getLog10GQ(genotype.getAlleles(), vcAlleles);
    }

    public double getLog10GQ(Genotype genotype, VariantContext context) {
        return this.getLog10GQ(genotype, context.getAlleles());
    }

    public static double getGQLog10FromLikelihoods(int iOfChoosenGenotype, double[] likelihoods) {
        if (likelihoods == null) {
            return Double.NEGATIVE_INFINITY;
        }
        double qual = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < likelihoods.length; ++i) {
            if (i == iOfChoosenGenotype || !(likelihoods[i] >= qual)) continue;
            qual = likelihoods[i];
        }
        if ((qual = likelihoods[iOfChoosenGenotype] - qual) < 0.0) {
            double[] normalized = GeneralUtils.normalizeFromLog10(likelihoods);
            double chosenGenotype = normalized[iOfChoosenGenotype];
            return Math.log10(1.0 - chosenGenotype);
        }
        return -1.0 * qual;
    }

    private static final double[] parsePLsIntoLikelihoods(String likelihoodsAsString_PLs) {
        if (likelihoodsAsString_PLs != null && !likelihoodsAsString_PLs.equals(".")) {
            String[] strings = likelihoodsAsString_PLs.split(",");
            double[] likelihoodsAsVector = new double[strings.length];
            try {
                for (int i = 0; i < strings.length; ++i) {
                    likelihoodsAsVector[i] = (double)Integer.parseInt(strings[i]) / -10.0;
                }
            }
            catch (NumberFormatException e) {
                throw new TribbleException("The GL/PL tag contains non-integer values: " + likelihoodsAsString_PLs);
            }
            return likelihoodsAsVector;
        }
        return null;
    }

    private static final double[] parseDeprecatedGLString(String GLString) {
        if (!GLString.equals(".")) {
            String[] strings = GLString.split(",");
            double[] likelihoodsAsVector = new double[strings.length];
            int missing = 0;
            for (int i = 0; i < strings.length; ++i) {
                if (strings[i].equals(".")) {
                    ++missing;
                    continue;
                }
                likelihoodsAsVector[i] = VCFUtils.parseVcfDouble(strings[i]);
            }
            if (missing == 0) {
                return likelihoodsAsVector;
            }
            if (likelihoodsAsVector.length == missing) {
                return null;
            }
            throw new TribbleException("partial missing values for GL field");
        }
        return null;
    }

    private static final String convertLikelihoodsToPLString(double[] GLs) {
        if (GLs == null) {
            return ".";
        }
        StringBuilder s = new StringBuilder();
        boolean first = true;
        for (int pl : GenotypeLikelihoods.GLsToPLs(GLs)) {
            if (!first) {
                s.append(',');
            } else {
                first = false;
            }
            s.append(pl);
        }
        return s.toString();
    }

    private static final int[] GLsToPLs(double[] GLs) {
        int[] pls = new int[GLs.length];
        double adjust = GenotypeLikelihoods.maxPL(GLs);
        for (int i = 0; i < GLs.length; ++i) {
            pls[i] = (int)Math.round(Math.min(-10.0 * (GLs[i] - adjust), 2.147483647E9));
        }
        return pls;
    }

    private static final double maxPL(double[] GLs) {
        double adjust = Double.NEGATIVE_INFINITY;
        for (double l : GLs) {
            adjust = Math.max(adjust, l);
        }
        return adjust;
    }

    private static final double[] PLsToGLs(int[] pls) {
        double[] likelihoodsAsVector = new double[pls.length];
        for (int i = 0; i < pls.length; ++i) {
            likelihoodsAsVector[i] = (double)pls[i] / -10.0;
        }
        return likelihoodsAsVector;
    }

    private static GenotypeLikelihoodsAllelePair[] calculateDiploidPLcache(int altAlleles) {
        int numLikelihoods = GenotypeLikelihoods.numLikelihoods(1 + altAlleles, 2);
        GenotypeLikelihoodsAllelePair[] cache = new GenotypeLikelihoodsAllelePair[numLikelihoods];
        for (int allele1 = 0; allele1 <= altAlleles; ++allele1) {
            for (int allele2 = allele1; allele2 <= altAlleles; ++allele2) {
                cache[GenotypeLikelihoods.calculatePLindex((int)allele1, (int)allele2)] = new GenotypeLikelihoodsAllelePair(allele1, allele2);
            }
        }
        for (int i = 0; i < cache.length; ++i) {
            if (cache[i] != null) continue;
            throw new IllegalStateException("BUG: cache entry " + i + " is unexpected null");
        }
        return cache;
    }

    private static void calculatePLIndexToAlleleIndices(int altAlleles, int ploidy, List<List<Integer>> anyploidPLIndexToAlleleIndices, List<Integer> genotype) {
        for (int a = 0; a <= altAlleles; ++a) {
            ArrayList<Integer> gt = new ArrayList<Integer>(Arrays.asList(a));
            gt.addAll(genotype);
            if (ploidy == 1) {
                anyploidPLIndexToAlleleIndices.add(gt);
                continue;
            }
            if (ploidy <= 1) continue;
            GenotypeLikelihoods.calculatePLIndexToAlleleIndices(a, ploidy - 1, anyploidPLIndexToAlleleIndices, gt);
        }
    }

    protected static List<List<Integer>> calculateAnyploidPLcache(int altAlleles, int ploidy) {
        ArrayList<List<Integer>> anyploidPLIndexToAlleleIndices = new ArrayList<List<Integer>>();
        GenotypeLikelihoods.calculatePLIndexToAlleleIndices(altAlleles, ploidy, anyploidPLIndexToAlleleIndices, new ArrayList<Integer>());
        return anyploidPLIndexToAlleleIndices;
    }

    static final int calcNumLikelihoods(int numAlleles, int ploidy) {
        return Math.toIntExact(BinomialCoefficientUtil.binomialCoefficient(numAlleles + ploidy - 1, ploidy));
    }

    public static synchronized int numLikelihoods(int numAlleles, int ploidy) {
        return numLikelihoodCache.get(numAlleles, ploidy);
    }

    public static int calculatePLindex(int allele1Index, int allele2Index) {
        return allele2Index * (allele2Index + 1) / 2 + allele1Index;
    }

    public static GenotypeLikelihoodsAllelePair getAllelePair(int PLindex) {
        if (PLindex < 0 || PLindex >= diploidPLIndexToAlleleIndex.length) {
            String msg = "The PL index " + PLindex + " cannot be " + (PLindex < 0 ? " negative" : " more than " + (diploidPLIndexToAlleleIndex.length - 1));
            throw new IllegalStateException(msg);
        }
        return diploidPLIndexToAlleleIndex[PLindex];
    }

    public static synchronized void initializeAnyploidPLIndexToAlleleIndices(int altAlleles, int ploidy) {
        if (altAlleles <= 0) {
            throw new IllegalArgumentException("Must have at least one alternate allele, not " + altAlleles);
        }
        if (ploidy <= 0) {
            throw new IllegalArgumentException("Ploidy must be at least 1, not " + ploidy);
        }
        anyploidPloidyToPLIndexToAlleleIndices.put(ploidy, GenotypeLikelihoods.calculateAnyploidPLcache(altAlleles, ploidy));
    }

    public static synchronized List<Integer> getAlleles(int PLindex, int ploidy) {
        if (ploidy == 2) {
            GenotypeLikelihoodsAllelePair pair = GenotypeLikelihoods.getAllelePair(PLindex);
            return Arrays.asList(pair.alleleIndex1, pair.alleleIndex2);
        }
        if (!anyploidPloidyToPLIndexToAlleleIndices.containsKey(ploidy)) {
            throw new IllegalStateException("Must initialize the cache of allele anyploid indices for ploidy " + ploidy);
        }
        if (PLindex < 0 || PLindex >= anyploidPloidyToPLIndexToAlleleIndices.get(ploidy).size()) {
            String msg = "The PL index " + PLindex + " does not exist for " + ploidy + " ploidy, " + (PLindex < 0 ? "cannot have a negative value." : "initialized the cache of allele anyploid indices with the incorrect number of alternate alleles.");
            throw new IllegalStateException(msg);
        }
        return anyploidPloidyToPLIndexToAlleleIndices.get(ploidy).get(PLindex);
    }

    @Deprecated
    public static GenotypeLikelihoodsAllelePair getAllelePairUsingDeprecatedOrdering(int PLindex) {
        return GenotypeLikelihoods.getAllelePair(PLindexConversion[PLindex]);
    }

    @Deprecated
    public static int[] getPLIndecesOfAlleles(int allele1Index, int allele2Index) {
        return GenotypeLikelihoods.getPLIndicesOfAlleles(allele1Index, allele2Index);
    }

    public static int[] getPLIndicesOfAlleles(int allele1Index, int allele2Index) {
        int[] indexes = new int[]{GenotypeLikelihoods.calculatePLindex(allele1Index, allele1Index), GenotypeLikelihoods.calculatePLindex(allele1Index, allele2Index), GenotypeLikelihoods.calculatePLindex(allele2Index, allele2Index)};
        return indexes;
    }

    public static class GenotypeLikelihoodsAllelePair {
        public final int alleleIndex1;
        public final int alleleIndex2;

        public GenotypeLikelihoodsAllelePair(int alleleIndex1, int alleleIndex2) {
            this.alleleIndex1 = alleleIndex1;
            this.alleleIndex2 = alleleIndex2;
        }
    }
}

